/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.languages;

import java.util.IllformedLocaleException;
import java.util.Objects;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.rio.LanguageHandler;

public class BCP47LanguageHandler
implements LanguageHandler {
    @Override
    public boolean isRecognizedLanguage(String languageTag) {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        try {
            Literals.normalizeLanguageTag(languageTag);
        }
        catch (IllformedLocaleException e2) {
            return false;
        }
        return true;
    }

    @Override
    public boolean verifyLanguage(String literalValue, String languageTag) throws LiteralUtilException {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        Objects.requireNonNull(literalValue, "Literal value cannot be null");
        if (this.isRecognizedLanguage(languageTag)) {
            return true;
        }
        throw new LiteralUtilException("Could not verify BCP47 language tag");
    }

    @Override
    public Literal normalizeLanguage(String literalValue, String languageTag, ValueFactory valueFactory) throws LiteralUtilException {
        Objects.requireNonNull(languageTag, "Language tag cannot be null");
        Objects.requireNonNull(literalValue, "Literal value cannot be null");
        try {
            return valueFactory.createLiteral(literalValue, Literals.normalizeLanguageTag(languageTag));
        }
        catch (IllformedLocaleException e2) {
            throw new LiteralUtilException("Could not normalize BCP47 language tag", e2);
        }
    }

    @Override
    public String getKey() {
        return "org.eclipse.rdf4j.rio.languages.BCP47";
    }
}

