/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBasicGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNode;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBlankNodePropertyList;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCollection;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class BlankNodeVarProcessor
extends AbstractASTVisitor {
    public static Set<String> process(ASTOperationContainer qc) throws MalformedQueryException {
        try {
            BlankNodeToVarConverter converter = new BlankNodeToVarConverter();
            qc.jjtAccept(converter, null);
            return converter.getUsedBNodeIDs();
        }
        catch (VisitorException e2) {
            throw new MalformedQueryException(e2);
        }
    }

    private static class BlankNodeToVarConverter
    extends AbstractASTVisitor {
        private int anonVarNo = 1;
        private Map<String, String> conversionMap = new HashMap<String, String>();
        private Set<String> usedBNodeIDs = new HashSet<String>();

        private BlankNodeToVarConverter() {
        }

        private String createAnonVarName() {
            return "_anon_" + this.anonVarNo++;
        }

        public Set<String> getUsedBNodeIDs() {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            return Collections.unmodifiableSet(this.usedBNodeIDs);
        }

        @Override
        public Object visit(ASTBasicGraphPattern node2, Object data2) throws VisitorException {
            this.usedBNodeIDs.addAll(this.conversionMap.keySet());
            this.conversionMap.clear();
            return super.visit(node2, data2);
        }

        @Override
        public Object visit(ASTBlankNode node2, Object data2) throws VisitorException {
            String bnodeID = node2.getID();
            String varName = this.findVarName(bnodeID);
            if (varName == null) {
                varName = this.createAnonVarName();
                if (bnodeID != null) {
                    this.conversionMap.put(bnodeID, varName);
                }
            }
            ASTVar varNode = new ASTVar(49);
            varNode.setName(varName);
            varNode.setAnonymous(true);
            node2.jjtReplaceWith(varNode);
            return super.visit(node2, data2);
        }

        private String findVarName(String bnodeID) throws VisitorException {
            if (bnodeID == null) {
                return null;
            }
            String varName = this.conversionMap.get(bnodeID);
            if (varName == null && this.usedBNodeIDs.contains(bnodeID)) {
                throw new VisitorException("BNodeID already used in another scope: " + bnodeID);
            }
            return varName;
        }

        @Override
        public Object visit(ASTBlankNodePropertyList node2, Object data2) throws VisitorException {
            node2.setVarName(this.createAnonVarName());
            return super.visit(node2, data2);
        }

        @Override
        public Object visit(ASTCollection node2, Object data2) throws VisitorException {
            node2.setVarName(this.createAnonVarName());
            return super.visit(node2, data2);
        }
    }
}

