/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.impl.SimpleBinding;

public class MapBindingSet
extends AbstractBindingSet {
    private static final long serialVersionUID = -8857324525220429607L;
    private final Map<String, Binding> bindings;

    public MapBindingSet() {
        this(8);
    }

    public MapBindingSet(int capacity) {
        this.bindings = new LinkedHashMap<String, Binding>(capacity * 2);
    }

    public void addBinding(String name2, Value value) {
        this.addBinding(new SimpleBinding(name2, value));
    }

    public void addBinding(Binding binding2) {
        this.bindings.put(binding2.getName(), binding2);
    }

    public void removeBinding(String name2) {
        this.bindings.remove(name2);
    }

    public void clear() {
        this.bindings.clear();
    }

    @Override
    public Iterator<Binding> iterator() {
        return this.bindings.values().iterator();
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    @Override
    public Binding getBinding(String bindingName) {
        return this.bindings.get(bindingName);
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    @Override
    public Value getValue(String bindingName) {
        Binding binding2 = this.getBinding(bindingName);
        if (binding2 != null) {
            return binding2.getValue();
        }
        return null;
    }

    @Override
    public int size() {
        return this.bindings.size();
    }
}

