/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DoubleCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                try {
                    double doubleValue = literal.doubleValue();
                    return valueFactory.createLiteral(doubleValue);
                }
                catch (NumberFormatException e2) {
                    throw new ValueExprEvaluationException(e2.getMessage(), e2);
                }
            }
            if (datatype.equals(XMLSchema.BOOLEAN)) {
                try {
                    return valueFactory.createLiteral(literal.booleanValue() ? 1.0 : 0.0);
                }
                catch (IllegalArgumentException e3) {
                    throw this.typeError(literal, e3);
                }
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.DOUBLE;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDouble(lexicalValue);
    }
}

