/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.eclipse.rdf4j.util.iterators.ConvertingIterator;

public class QueryBindingSet
extends AbstractBindingSet {
    private static final long serialVersionUID = -2010715346095527301L;
    private final Map<String, Value> bindings;

    public QueryBindingSet() {
        this(8);
    }

    public QueryBindingSet(int capacity) {
        this.bindings = new HashMap<String, Value>(capacity * 2);
    }

    public QueryBindingSet(BindingSet bindingSet) {
        this(bindingSet.size());
        this.addAll(bindingSet);
    }

    public void addAll(BindingSet bindingSet) {
        if (bindingSet instanceof QueryBindingSet) {
            this.bindings.putAll(((QueryBindingSet)bindingSet).bindings);
        } else {
            for (Binding binding2 : bindingSet) {
                this.addBinding(binding2);
            }
        }
    }

    public void addBinding(Binding binding2) {
        this.addBinding(binding2.getName(), binding2.getValue());
    }

    public void addBinding(String name2, Value value) {
        assert (!this.bindings.containsKey(name2)) : "variable already bound: " + name2;
        this.setBinding(name2, value);
    }

    public void setBinding(Binding binding2) {
        this.setBinding(binding2.getName(), binding2.getValue());
    }

    public void setBinding(String name2, Value value) {
        assert (value != null) : "null value for variable " + name2;
        this.bindings.put(name2, value);
    }

    public void removeBinding(String name2) {
        this.bindings.remove(name2);
    }

    public void removeAll(Collection<String> bindingNames) {
        this.bindings.keySet().removeAll(bindingNames);
    }

    public void retainAll(Collection<String> bindingNames) {
        this.bindings.keySet().retainAll(bindingNames);
    }

    @Override
    public Set<String> getBindingNames() {
        return this.bindings.keySet();
    }

    @Override
    public Value getValue(String bindingName) {
        return this.bindings.get(bindingName);
    }

    @Override
    public Binding getBinding(String bindingName) {
        Value value = this.getValue(bindingName);
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    @Override
    public boolean hasBinding(String bindingName) {
        return this.bindings.containsKey(bindingName);
    }

    @Override
    public Iterator<Binding> iterator() {
        Iterator<Map.Entry<String, Value>> entries = this.bindings.entrySet().iterator();
        return new ConvertingIterator<Map.Entry<String, Value>, Binding>(entries){

            @Override
            protected Binding convert(Map.Entry<String, Value> entry) {
                return new SimpleBinding(entry.getKey(), entry.getValue());
            }
        };
    }

    @Override
    public int size() {
        return this.bindings.size();
    }

    @Override
    public boolean equals(Object other) {
        if (other instanceof QueryBindingSet) {
            return this.bindings.equals(((QueryBindingSet)other).bindings);
        }
        return super.equals(other);
    }
}

