/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.join.BitDocIdSetFilter;
import org.apache.lucene.search.join.ToParentBlockJoinFieldComparator;

public class ToParentBlockJoinSortField
extends SortField {
    private final boolean order;
    private final BitDocIdSetFilter parentFilter;
    private final BitDocIdSetFilter childFilter;

    public ToParentBlockJoinSortField(String field, SortField.Type type2, boolean reverse2, BitDocIdSetFilter parentFilter, BitDocIdSetFilter childFilter) {
        super(field, type2, reverse2);
        this.order = reverse2;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    public ToParentBlockJoinSortField(String field, SortField.Type type2, boolean reverse2, boolean order, BitDocIdSetFilter parentFilter, BitDocIdSetFilter childFilter) {
        super(field, type2, reverse2);
        this.order = order;
        this.parentFilter = parentFilter;
        this.childFilter = childFilter;
    }

    @Override
    public FieldComparator<?> getComparator(int numHits, int sortPos) throws IOException {
        FieldComparator<Object> wrappedFieldComparator = super.getComparator(numHits + 1, sortPos);
        if (this.order) {
            return new ToParentBlockJoinFieldComparator.Highest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
        }
        return new ToParentBlockJoinFieldComparator.Lowest(wrappedFieldComparator, this.parentFilter, this.childFilter, numHits);
    }
}

