/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queryparser.flexible.standard.processors;

import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.queryparser.flexible.core.QueryNodeException;
import org.apache.lucene.queryparser.flexible.core.config.QueryConfigHandler;
import org.apache.lucene.queryparser.flexible.core.nodes.AndQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.BooleanQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.ModifierQueryNode;
import org.apache.lucene.queryparser.flexible.core.nodes.QueryNode;
import org.apache.lucene.queryparser.flexible.core.processors.QueryNodeProcessor;
import org.apache.lucene.queryparser.flexible.standard.config.StandardQueryConfigHandler;
import org.apache.lucene.queryparser.flexible.standard.nodes.BooleanModifierNode;

public class BooleanQuery2ModifierNodeProcessor
implements QueryNodeProcessor {
    static final String TAG_REMOVE = "remove";
    static final String TAG_MODIFIER = "wrapWithModifier";
    static final String TAG_BOOLEAN_ROOT = "booleanRoot";
    QueryConfigHandler queryConfigHandler;
    private final ArrayList<QueryNode> childrenBuffer = new ArrayList();
    private Boolean usingAnd = false;

    @Override
    public QueryNode process(QueryNode queryTree) throws QueryNodeException {
        StandardQueryConfigHandler.Operator op = this.getQueryConfigHandler().get(StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR);
        if (op == null) {
            throw new IllegalArgumentException("StandardQueryConfigHandler.ConfigurationKeys.DEFAULT_OPERATOR should be set on the QueryConfigHandler");
        }
        this.usingAnd = StandardQueryConfigHandler.Operator.AND == op;
        return this.processIteration(queryTree);
    }

    protected void processChildren(QueryNode queryTree) throws QueryNodeException {
        List<QueryNode> children2 = queryTree.getChildren();
        if (children2 != null && children2.size() > 0) {
            for (QueryNode child : children2) {
                child = this.processIteration(child);
            }
        }
    }

    private QueryNode processIteration(QueryNode queryTree) throws QueryNodeException {
        queryTree = this.preProcessNode(queryTree);
        this.processChildren(queryTree);
        queryTree = this.postProcessNode(queryTree);
        return queryTree;
    }

    protected void fillChildrenBufferAndApplyModifiery(QueryNode parent) {
        for (QueryNode node2 : parent.getChildren()) {
            if (node2.containsTag(TAG_REMOVE)) {
                this.fillChildrenBufferAndApplyModifiery(node2);
                continue;
            }
            if (node2.containsTag(TAG_MODIFIER)) {
                this.childrenBuffer.add(this.applyModifier(node2, (ModifierQueryNode.Modifier)((Object)node2.getTag(TAG_MODIFIER))));
                continue;
            }
            this.childrenBuffer.add(node2);
        }
    }

    protected QueryNode postProcessNode(QueryNode node2) throws QueryNodeException {
        if (node2.containsTag(TAG_BOOLEAN_ROOT)) {
            this.childrenBuffer.clear();
            this.fillChildrenBufferAndApplyModifiery(node2);
            node2.set(this.childrenBuffer);
        }
        return node2;
    }

    protected QueryNode preProcessNode(QueryNode node2) throws QueryNodeException {
        QueryNode parent = node2.getParent();
        if (node2 instanceof BooleanQueryNode) {
            if (parent instanceof BooleanQueryNode) {
                node2.setTag(TAG_REMOVE, Boolean.TRUE);
            } else {
                node2.setTag(TAG_BOOLEAN_ROOT, Boolean.TRUE);
            }
        } else if (parent instanceof BooleanQueryNode && (parent instanceof AndQueryNode || this.usingAnd.booleanValue() && this.isDefaultBooleanQueryNode(parent))) {
            this.tagModifierButDoNotOverride(node2, ModifierQueryNode.Modifier.MOD_REQ);
        }
        return node2;
    }

    protected boolean isDefaultBooleanQueryNode(QueryNode toTest) {
        return toTest != null && BooleanQueryNode.class.equals(toTest.getClass());
    }

    private QueryNode applyModifier(QueryNode node2, ModifierQueryNode.Modifier mod2) {
        if (!(node2 instanceof ModifierQueryNode)) {
            return new BooleanModifierNode(node2, mod2);
        }
        ModifierQueryNode modNode = (ModifierQueryNode)node2;
        if (modNode.getModifier() == ModifierQueryNode.Modifier.MOD_NONE) {
            return new ModifierQueryNode(modNode.getChild(), mod2);
        }
        return node2;
    }

    protected void tagModifierButDoNotOverride(QueryNode node2, ModifierQueryNode.Modifier mod2) {
        if (node2 instanceof ModifierQueryNode) {
            ModifierQueryNode modNode = (ModifierQueryNode)node2;
            if (modNode.getModifier() == ModifierQueryNode.Modifier.MOD_NONE) {
                node2.setTag(TAG_MODIFIER, (Object)mod2);
            }
        } else {
            node2.setTag(TAG_MODIFIER, (Object)ModifierQueryNode.Modifier.MOD_REQ);
        }
    }

    @Override
    public void setQueryConfigHandler(QueryConfigHandler queryConfigHandler) {
        this.queryConfigHandler = queryConfigHandler;
    }

    @Override
    public QueryConfigHandler getQueryConfigHandler() {
        return this.queryConfigHandler;
    }
}

