/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.queries.function.valuesource;

import java.io.IOException;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.valuesource.BoolFunction;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.util.BytesRefBuilder;

public class IfFunction
extends BoolFunction {
    private final ValueSource ifSource;
    private final ValueSource trueSource;
    private final ValueSource falseSource;

    public IfFunction(ValueSource ifSource, ValueSource trueSource, ValueSource falseSource) {
        this.ifSource = ifSource;
        this.trueSource = trueSource;
        this.falseSource = falseSource;
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues ifVals = this.ifSource.getValues(context, readerContext);
        final FunctionValues trueVals = this.trueSource.getValues(context, readerContext);
        final FunctionValues falseVals = this.falseSource.getValues(context, readerContext);
        return new FunctionValues(){

            @Override
            public byte byteVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.byteVal(doc2) : falseVals.byteVal(doc2);
            }

            @Override
            public short shortVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.shortVal(doc2) : falseVals.shortVal(doc2);
            }

            @Override
            public float floatVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.floatVal(doc2) : falseVals.floatVal(doc2);
            }

            @Override
            public int intVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.intVal(doc2) : falseVals.intVal(doc2);
            }

            @Override
            public long longVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.longVal(doc2) : falseVals.longVal(doc2);
            }

            @Override
            public double doubleVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.doubleVal(doc2) : falseVals.doubleVal(doc2);
            }

            @Override
            public String strVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.strVal(doc2) : falseVals.strVal(doc2);
            }

            @Override
            public boolean boolVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.boolVal(doc2) : falseVals.boolVal(doc2);
            }

            @Override
            public boolean bytesVal(int doc2, BytesRefBuilder target) {
                return ifVals.boolVal(doc2) ? trueVals.bytesVal(doc2, target) : falseVals.bytesVal(doc2, target);
            }

            @Override
            public Object objectVal(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.objectVal(doc2) : falseVals.objectVal(doc2);
            }

            @Override
            public boolean exists(int doc2) {
                return ifVals.boolVal(doc2) ? trueVals.exists(doc2) : falseVals.exists(doc2);
            }

            @Override
            public FunctionValues.ValueFiller getValueFiller() {
                return super.getValueFiller();
            }

            @Override
            public String toString(int doc2) {
                return "if(" + ifVals.toString(doc2) + ',' + trueVals.toString(doc2) + ',' + falseVals.toString(doc2) + ')';
            }
        };
    }

    @Override
    public String description() {
        return "if(" + this.ifSource.description() + ',' + this.trueSource.description() + ',' + this.falseSource + ')';
    }

    @Override
    public int hashCode() {
        int h = this.ifSource.hashCode();
        h = h * 31 + this.trueSource.hashCode();
        h = h * 31 + this.falseSource.hashCode();
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof IfFunction)) {
            return false;
        }
        IfFunction other = (IfFunction)o;
        return this.ifSource.equals(other.ifSource) && this.trueSource.equals(other.trueSource) && this.falseSource.equals(other.falseSource);
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.ifSource.createWeight(context, searcher);
        this.trueSource.createWeight(context, searcher);
        this.falseSource.createWeight(context, searcher);
    }
}

