/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene50;

import java.io.IOException;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.lucene50.Lucene50CompoundReader;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

public final class Lucene50CompoundFormat
extends CompoundFormat {
    static final String DATA_EXTENSION = "cfs";
    static final String ENTRIES_EXTENSION = "cfe";
    static final String DATA_CODEC = "Lucene50CompoundData";
    static final String ENTRY_CODEC = "Lucene50CompoundEntries";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    @Override
    public Directory getCompoundReader(Directory dir2, SegmentInfo si, IOContext context) throws IOException {
        return new Lucene50CompoundReader(dir2, si, context);
    }

    @Override
    public void write(Directory dir2, SegmentInfo si, IOContext context) throws IOException {
        String dataFile = IndexFileNames.segmentFileName(si.name, "", DATA_EXTENSION);
        String entriesFile = IndexFileNames.segmentFileName(si.name, "", ENTRIES_EXTENSION);
        try (IndexOutput data2 = dir2.createOutput(dataFile, context);
             IndexOutput entries = dir2.createOutput(entriesFile, context);){
            CodecUtil.writeIndexHeader(data2, DATA_CODEC, 0, si.getId(), "");
            CodecUtil.writeIndexHeader(entries, ENTRY_CODEC, 0, si.getId(), "");
            entries.writeVInt(si.files().size());
            for (String file2 : si.files()) {
                long startOffset = data2.getFilePointer();
                try (IndexInput in = dir2.openInput(file2, IOContext.READONCE);){
                    data2.copyBytes(in, in.length());
                }
                long endOffset = data2.getFilePointer();
                long length = endOffset - startOffset;
                entries.writeString(IndexFileNames.stripSegmentName(file2));
                entries.writeLong(startOffset);
                entries.writeLong(length);
            }
            CodecUtil.writeFooter(data2);
            CodecUtil.writeFooter(entries);
        }
    }
}

