/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.BufferedChecksumIndexInput;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.StringHelper;

public final class CodecUtil {
    public static final int CODEC_MAGIC = 1071082519;
    public static final int FOOTER_MAGIC = -1071082520;

    private CodecUtil() {
    }

    public static void writeHeader(DataOutput out, String codec, int version2) throws IOException {
        BytesRef bytes2 = new BytesRef(codec);
        if (bytes2.length != codec.length() || bytes2.length >= 128) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 128 characters in length [got " + codec + "]");
        }
        out.writeInt(1071082519);
        out.writeString(codec);
        out.writeInt(version2);
    }

    public static void writeIndexHeader(DataOutput out, String codec, int version2, byte[] id, String suffix) throws IOException {
        if (id.length != 16) {
            throw new IllegalArgumentException("Invalid id: " + StringHelper.idToString(id));
        }
        CodecUtil.writeHeader(out, codec, version2);
        out.writeBytes(id, 0, id.length);
        BytesRef suffixBytes = new BytesRef(suffix);
        if (suffixBytes.length != suffix.length() || suffixBytes.length >= 256) {
            throw new IllegalArgumentException("codec must be simple ASCII, less than 256 characters in length [got " + suffix + "]");
        }
        out.writeByte((byte)suffixBytes.length);
        out.writeBytes(suffixBytes.bytes, suffixBytes.offset, suffixBytes.length);
    }

    public static int headerLength(String codec) {
        return 9 + codec.length();
    }

    public static int indexHeaderLength(String codec, String suffix) {
        return CodecUtil.headerLength(codec) + 16 + 1 + suffix.length();
    }

    public static int checkHeader(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        int actualHeader = in.readInt();
        if (actualHeader != 1071082519) {
            throw new CorruptIndexException("codec header mismatch: actual header=" + actualHeader + " vs expected header=" + 1071082519, in);
        }
        return CodecUtil.checkHeaderNoMagic(in, codec, minVersion, maxVersion);
    }

    public static int checkHeaderNoMagic(DataInput in, String codec, int minVersion, int maxVersion) throws IOException {
        String actualCodec = in.readString();
        if (!actualCodec.equals(codec)) {
            throw new CorruptIndexException("codec mismatch: actual codec=" + actualCodec + " vs expected codec=" + codec, in);
        }
        int actualVersion = in.readInt();
        if (actualVersion < minVersion) {
            throw new IndexFormatTooOldException(in, actualVersion, minVersion, maxVersion);
        }
        if (actualVersion > maxVersion) {
            throw new IndexFormatTooNewException(in, actualVersion, minVersion, maxVersion);
        }
        return actualVersion;
    }

    public static int checkIndexHeader(DataInput in, String codec, int minVersion, int maxVersion, byte[] expectedID, String expectedSuffix) throws IOException {
        int version2 = CodecUtil.checkHeader(in, codec, minVersion, maxVersion);
        CodecUtil.checkIndexHeaderID(in, expectedID);
        CodecUtil.checkIndexHeaderSuffix(in, expectedSuffix);
        return version2;
    }

    public static byte[] checkIndexHeaderID(DataInput in, byte[] expectedID) throws IOException {
        byte[] id = new byte[16];
        in.readBytes(id, 0, id.length);
        if (!Arrays.equals(id, expectedID)) {
            throw new CorruptIndexException("file mismatch, expected id=" + StringHelper.idToString(expectedID) + ", got=" + StringHelper.idToString(id), in);
        }
        return id;
    }

    public static String checkIndexHeaderSuffix(DataInput in, String expectedSuffix) throws IOException {
        int suffixLength = in.readByte() & 0xFF;
        byte[] suffixBytes = new byte[suffixLength];
        in.readBytes(suffixBytes, 0, suffixBytes.length);
        String suffix = new String(suffixBytes, 0, suffixBytes.length, StandardCharsets.UTF_8);
        if (!suffix.equals(expectedSuffix)) {
            throw new CorruptIndexException("file mismatch, expected suffix=" + expectedSuffix + ", got=" + suffix, in);
        }
        return suffix;
    }

    public static void writeFooter(IndexOutput out) throws IOException {
        out.writeInt(-1071082520);
        out.writeInt(0);
        out.writeLong(out.getChecksum());
    }

    public static int footerLength() {
        return 16;
    }

    public static long checkFooter(ChecksumIndexInput in) throws IOException {
        CodecUtil.validateFooter(in);
        long actualChecksum = in.getChecksum();
        long expectedChecksum = in.readLong();
        if (expectedChecksum != actualChecksum) {
            throw new CorruptIndexException("checksum failed (hardware problem?) : expected=" + Long.toHexString(expectedChecksum) + " actual=" + Long.toHexString(actualChecksum), in);
        }
        return actualChecksum;
    }

    public static void checkFooter(ChecksumIndexInput in, Throwable priorException) throws IOException {
        if (priorException == null) {
            CodecUtil.checkFooter(in);
        } else {
            try {
                long remaining = in.length() - in.getFilePointer();
                if (remaining < (long)CodecUtil.footerLength()) {
                    priorException.addSuppressed(new CorruptIndexException("checksum status indeterminate: remaining=" + remaining + ", please run checkindex for more details", in));
                } else {
                    in.skipBytes(remaining - (long)CodecUtil.footerLength());
                    try {
                        long checksum = CodecUtil.checkFooter(in);
                        priorException.addSuppressed(new CorruptIndexException("checksum passed (" + Long.toHexString(checksum) + "). possibly transient resource issue, or a Lucene or JVM bug", in));
                    }
                    catch (CorruptIndexException t) {
                        priorException.addSuppressed(t);
                    }
                }
            }
            catch (Throwable t) {
                priorException.addSuppressed(new CorruptIndexException("checksum status indeterminate: unexpected exception", in, t));
            }
            IOUtils.reThrow(priorException);
        }
    }

    public static long retrieveChecksum(IndexInput in) throws IOException {
        in.seek(in.length() - (long)CodecUtil.footerLength());
        CodecUtil.validateFooter(in);
        return in.readLong();
    }

    private static void validateFooter(IndexInput in) throws IOException {
        long expected;
        long remaining = in.length() - in.getFilePointer();
        if (remaining < (expected = (long)CodecUtil.footerLength())) {
            throw new CorruptIndexException("misplaced codec footer (file truncated?): remaining=" + remaining + ", expected=" + expected, in);
        }
        if (remaining > expected) {
            throw new CorruptIndexException("misplaced codec footer (file extended?): remaining=" + remaining + ", expected=" + expected, in);
        }
        int magic = in.readInt();
        if (magic != -1071082520) {
            throw new CorruptIndexException("codec footer mismatch (file truncated?): actual footer=" + magic + " vs expected footer=" + -1071082520, in);
        }
        int algorithmID = in.readInt();
        if (algorithmID != 0) {
            throw new CorruptIndexException("codec footer mismatch: unknown algorithmID: " + algorithmID, in);
        }
    }

    @Deprecated
    public static void checkEOF(IndexInput in) throws IOException {
        if (in.getFilePointer() != in.length()) {
            throw new CorruptIndexException("did not read all bytes from file: read " + in.getFilePointer() + " vs size " + in.length(), in);
        }
    }

    public static long checksumEntireFile(IndexInput input) throws IOException {
        IndexInput clone = input.clone();
        clone.seek(0L);
        BufferedChecksumIndexInput in = new BufferedChecksumIndexInput(clone);
        assert (((IndexInput)in).getFilePointer() == 0L);
        in.seek(((IndexInput)in).length() - (long)CodecUtil.footerLength());
        return CodecUtil.checkFooter(in);
    }
}

