/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.core;

import java.io.IOException;
import java.io.Reader;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.LowerCaseTokenizer;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.util.CharArraySet;
import org.apache.lucene.analysis.util.StopwordAnalyzerBase;

public final class StopAnalyzer
extends StopwordAnalyzerBase {
    public static final CharArraySet ENGLISH_STOP_WORDS_SET;

    public StopAnalyzer() {
        this(ENGLISH_STOP_WORDS_SET);
    }

    public StopAnalyzer(CharArraySet stopWords) {
        super(stopWords);
    }

    public StopAnalyzer(Path stopwordsFile) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwordsFile));
    }

    public StopAnalyzer(Reader stopwords) throws IOException {
        this(StopAnalyzer.loadStopwordSet(stopwords));
    }

    @Override
    protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
        LowerCaseTokenizer source2 = new LowerCaseTokenizer();
        return new Analyzer.TokenStreamComponents(source2, new StopFilter(source2, this.stopwords));
    }

    static {
        List<String> stopWords = Arrays.asList("a", "an", "and", "are", "as", "at", "be", "but", "by", "for", "if", "in", "into", "is", "it", "no", "not", "of", "on", "or", "such", "that", "the", "their", "then", "there", "these", "they", "this", "to", "was", "will", "with");
        CharArraySet stopSet = new CharArraySet(stopWords, false);
        ENGLISH_STOP_WORDS_SET = CharArraySet.unmodifiableSet(stopSet);
    }
}

