/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang;

import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.SystemUtils;

public class WordUtils {
    public static String wrap(String str2, int wrapLength) {
        return WordUtils.wrap(str2, wrapLength, null, false);
    }

    public static String wrap(String str2, int wrapLength, String newLineStr, boolean wrapLongWords) {
        if (str2 == null) {
            return null;
        }
        if (newLineStr == null) {
            newLineStr = SystemUtils.LINE_SEPARATOR;
        }
        if (wrapLength < 1) {
            wrapLength = 1;
        }
        int inputLineLength = str2.length();
        int offset = 0;
        StringBuffer wrappedLine = new StringBuffer(inputLineLength + 32);
        while (inputLineLength - offset > wrapLength) {
            if (str2.charAt(offset) == ' ') {
                ++offset;
                continue;
            }
            int spaceToWrapAt = str2.lastIndexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= offset) {
                wrappedLine.append(str2.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            if (wrapLongWords) {
                wrappedLine.append(str2.substring(offset, wrapLength + offset));
                wrappedLine.append(newLineStr);
                offset += wrapLength;
                continue;
            }
            spaceToWrapAt = str2.indexOf(32, wrapLength + offset);
            if (spaceToWrapAt >= 0) {
                wrappedLine.append(str2.substring(offset, spaceToWrapAt));
                wrappedLine.append(newLineStr);
                offset = spaceToWrapAt + 1;
                continue;
            }
            wrappedLine.append(str2.substring(offset));
            offset = inputLineLength;
        }
        wrappedLine.append(str2.substring(offset));
        return wrappedLine.toString();
    }

    public static String capitalize(String str2) {
        return WordUtils.capitalize(str2, null);
    }

    public static String capitalize(String str2, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str2 == null || str2.length() == 0 || delimLen == 0) {
            return str2;
        }
        int strLen = str2.length();
        StringBuffer buffer = new StringBuffer(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str2.charAt(i);
            if (WordUtils.isDelimiter(ch, delimiters)) {
                buffer.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String capitalizeFully(String str2) {
        return WordUtils.capitalizeFully(str2, null);
    }

    public static String capitalizeFully(String str2, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str2 == null || str2.length() == 0 || delimLen == 0) {
            return str2;
        }
        str2 = str2.toLowerCase();
        return WordUtils.capitalize(str2, delimiters);
    }

    public static String uncapitalize(String str2) {
        return WordUtils.uncapitalize(str2, null);
    }

    public static String uncapitalize(String str2, char[] delimiters) {
        int delimLen;
        int n = delimLen = delimiters == null ? -1 : delimiters.length;
        if (str2 == null || str2.length() == 0 || delimLen == 0) {
            return str2;
        }
        int strLen = str2.length();
        StringBuffer buffer = new StringBuffer(strLen);
        boolean uncapitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str2.charAt(i);
            if (WordUtils.isDelimiter(ch, delimiters)) {
                buffer.append(ch);
                uncapitalizeNext = true;
                continue;
            }
            if (uncapitalizeNext) {
                buffer.append(Character.toLowerCase(ch));
                uncapitalizeNext = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String swapCase(String str2) {
        int strLen;
        if (str2 == null || (strLen = str2.length()) == 0) {
            return str2;
        }
        StringBuffer buffer = new StringBuffer(strLen);
        boolean whitespace = true;
        char ch = '\u0000';
        char tmp = '\u0000';
        for (int i = 0; i < strLen; ++i) {
            ch = str2.charAt(i);
            tmp = Character.isUpperCase(ch) ? Character.toLowerCase(ch) : (Character.isTitleCase(ch) ? Character.toLowerCase(ch) : (Character.isLowerCase(ch) ? (whitespace ? Character.toTitleCase(ch) : Character.toUpperCase(ch)) : ch));
            buffer.append(tmp);
            whitespace = Character.isWhitespace(ch);
        }
        return buffer.toString();
    }

    public static String initials(String str2) {
        return WordUtils.initials(str2, null);
    }

    public static String initials(String str2, char[] delimiters) {
        if (str2 == null || str2.length() == 0) {
            return str2;
        }
        if (delimiters != null && delimiters.length == 0) {
            return "";
        }
        int strLen = str2.length();
        char[] buf = new char[strLen / 2 + 1];
        int count2 = 0;
        boolean lastWasGap = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str2.charAt(i);
            if (WordUtils.isDelimiter(ch, delimiters)) {
                lastWasGap = true;
                continue;
            }
            if (!lastWasGap) continue;
            buf[count2++] = ch;
            lastWasGap = false;
        }
        return new String(buf, 0, count2);
    }

    private static boolean isDelimiter(char ch, char[] delimiters) {
        if (delimiters == null) {
            return Character.isWhitespace(ch);
        }
        int isize = delimiters.length;
        for (int i = 0; i < isize; ++i) {
            if (ch != delimiters[i]) continue;
            return true;
        }
        return false;
    }

    public static String abbreviate(String str2, int lower, int upper, String appendToEnd) {
        if (str2 == null) {
            return null;
        }
        if (str2.length() == 0) {
            return "";
        }
        if (lower > str2.length()) {
            lower = str2.length();
        }
        if (upper == -1 || upper > str2.length()) {
            upper = str2.length();
        }
        if (upper < lower) {
            upper = lower;
        }
        StringBuffer result = new StringBuffer();
        int index2 = StringUtils.indexOf(str2, " ", lower);
        if (index2 == -1) {
            result.append(str2.substring(0, upper));
            if (upper != str2.length()) {
                result.append(StringUtils.defaultString(appendToEnd));
            }
        } else if (index2 > upper) {
            result.append(str2.substring(0, upper));
            result.append(StringUtils.defaultString(appendToEnd));
        } else {
            result.append(str2.substring(0, index2));
            result.append(StringUtils.defaultString(appendToEnd));
        }
        return result.toString();
    }
}

