/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Random;
import org.mapdb.LongMap;

public class LongHashMap<V>
extends LongMap<V>
implements Serializable {
    private static final long serialVersionUID = 362340234235222265L;
    transient int elementCount;
    transient Entry<V>[] elementData;
    transient int modCount = 0;
    private static final int DEFAULT_SIZE = 16;
    final float loadFactor;
    protected final long hashSalt = this.hashSaltValue();
    int threshold;

    protected long hashSaltValue() {
        return new Random().nextLong();
    }

    Entry<V>[] newElementArray(int s) {
        return new Entry[s];
    }

    public LongHashMap() {
        this(16);
    }

    public LongHashMap(int capacity) {
        this(capacity, 0.75f);
    }

    private static int calculateCapacity(int x) {
        if (x >= 0x40000000) {
            return 0x40000000;
        }
        if (x == 0) {
            return 16;
        }
        --x;
        x |= x >> 1;
        x |= x >> 2;
        x |= x >> 4;
        x |= x >> 8;
        x |= x >> 16;
        return x + 1;
    }

    public LongHashMap(int capacity, float loadFactor) {
        if (capacity < 0 || !(loadFactor > 0.0f)) {
            throw new IllegalArgumentException();
        }
        capacity = LongHashMap.calculateCapacity(capacity);
        this.elementCount = 0;
        this.elementData = this.newElementArray(capacity);
        this.loadFactor = loadFactor;
        this.computeThreshold();
    }

    @Override
    public void clear() {
        if (this.elementCount > 0) {
            this.elementCount = 0;
            Arrays.fill(this.elementData, null);
            ++this.modCount;
        }
    }

    private void computeThreshold() {
        this.threshold = (int)((float)this.elementData.length * this.loadFactor);
    }

    @Override
    public V get(long key2) {
        Entry<V> m = this.getEntry(key2);
        if (m != null) {
            return m.value;
        }
        return null;
    }

    final Entry<V> getEntry(long key2) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        int index2 = hash2 & this.elementData.length - 1;
        return this.findNonNullKeyEntry(key2, index2, hash2);
    }

    final Entry<V> findNonNullKeyEntry(long key2, int index2, int keyHash) {
        Entry<V> m = this.elementData[index2];
        while (m != null && (m.origKeyHash != keyHash || key2 != m.key)) {
            m = m.next;
        }
        return m;
    }

    @Override
    public boolean isEmpty() {
        return this.elementCount == 0;
    }

    @Override
    public V put(long key2, V value) {
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        int index2 = hash2 & this.elementData.length - 1;
        Entry<V> entry = this.findNonNullKeyEntry(key2, index2, hash2);
        if (entry == null) {
            ++this.modCount;
            entry = this.createHashedEntry(key2, index2, hash2);
            if (++this.elementCount > this.threshold) {
                this.rehash();
            }
        }
        Object result = entry.value;
        entry.value = value;
        return result;
    }

    Entry<V> createHashedEntry(long key2, int index2, int hash2) {
        Entry entry = new Entry(key2, hash2);
        entry.next = this.elementData[index2];
        this.elementData[index2] = entry;
        return entry;
    }

    void rehash(int capacity) {
        int length = LongHashMap.calculateCapacity(capacity == 0 ? 1 : capacity << 1);
        Entry<V>[] newData = this.newElementArray(length);
        for (int i = 0; i < this.elementData.length; ++i) {
            Entry<V> entry = this.elementData[i];
            this.elementData[i] = null;
            while (entry != null) {
                int index2 = entry.origKeyHash & length - 1;
                Entry next2 = entry.next;
                entry.next = newData[index2];
                newData[index2] = entry;
                entry = next2;
            }
        }
        this.elementData = newData;
        this.computeThreshold();
    }

    void rehash() {
        this.rehash(this.elementData.length);
    }

    @Override
    public V remove(long key2) {
        Entry<V> entry = this.removeEntry(key2);
        if (entry != null) {
            return entry.value;
        }
        return null;
    }

    final Entry<V> removeEntry(long key2) {
        int index2 = 0;
        Entry<V> last = null;
        int hash2 = LongHashMap.longHash(key2 ^ this.hashSalt);
        index2 = hash2 & this.elementData.length - 1;
        Entry<V> entry = this.elementData[index2];
        while (entry != null && (entry.origKeyHash != hash2 || key2 != entry.key)) {
            last = entry;
            entry = entry.next;
        }
        if (entry == null) {
            return null;
        }
        if (last == null) {
            this.elementData[index2] = entry.next;
        } else {
            last.next = entry.next;
        }
        ++this.modCount;
        --this.elementCount;
        return entry;
    }

    @Override
    public int size() {
        return this.elementCount;
    }

    @Override
    public Iterator<V> valuesIterator() {
        return new ValueIterator(this);
    }

    @Override
    public LongMap.LongMapIterator<V> longMapIterator() {
        return new EntryIterator(this);
    }

    public static int longHash(long key2) {
        int h = (int)(key2 ^ key2 >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    public static int intHash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private static class ValueIterator<V>
    extends AbstractMapIterator<V>
    implements Iterator<V> {
        ValueIterator(LongHashMap<V> map2) {
            super(map2);
        }

        @Override
        public V next() {
            this.makeNext();
            return this.currentEntry.value;
        }
    }

    private static class EntryIterator<V>
    extends AbstractMapIterator<V>
    implements LongMap.LongMapIterator<V> {
        EntryIterator(LongHashMap<V> map2) {
            super(map2);
        }

        @Override
        public boolean moveToNext() {
            if (!this.hasNext()) {
                return false;
            }
            this.makeNext();
            return true;
        }

        @Override
        public long key() {
            return this.currentEntry.key;
        }

        @Override
        public V value() {
            return this.currentEntry.value;
        }
    }

    private static class AbstractMapIterator<V> {
        private int position = 0;
        int expectedModCount;
        Entry<V> futureEntry;
        Entry<V> currentEntry;
        Entry<V> prevEntry;
        final LongHashMap<V> associatedMap;

        AbstractMapIterator(LongHashMap<V> hm) {
            this.associatedMap = hm;
            this.expectedModCount = hm.modCount;
            this.futureEntry = null;
        }

        public boolean hasNext() {
            if (this.futureEntry != null) {
                return true;
            }
            while (this.position < this.associatedMap.elementData.length) {
                if (this.associatedMap.elementData[this.position] == null) {
                    ++this.position;
                    continue;
                }
                return true;
            }
            return false;
        }

        final void checkConcurrentMod() throws ConcurrentModificationException {
            if (this.expectedModCount != this.associatedMap.modCount) {
                throw new ConcurrentModificationException();
            }
        }

        final void makeNext() {
            this.checkConcurrentMod();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.futureEntry == null) {
                this.currentEntry = this.associatedMap.elementData[this.position++];
                this.futureEntry = this.currentEntry.next;
                this.prevEntry = null;
            } else {
                if (this.currentEntry != null) {
                    this.prevEntry = this.currentEntry;
                }
                this.currentEntry = this.futureEntry;
                this.futureEntry = this.futureEntry.next;
            }
        }

        public final void remove() {
            this.checkConcurrentMod();
            if (this.currentEntry == null) {
                throw new IllegalStateException();
            }
            if (this.prevEntry == null) {
                int index2 = this.currentEntry.origKeyHash & this.associatedMap.elementData.length - 1;
                this.associatedMap.elementData[index2] = this.associatedMap.elementData[index2].next;
            } else {
                this.prevEntry.next = this.currentEntry.next;
            }
            this.currentEntry = null;
            ++this.expectedModCount;
            ++this.associatedMap.modCount;
            --this.associatedMap.elementCount;
        }
    }

    static class Entry<V> {
        final int origKeyHash;
        final long key;
        V value;
        Entry<V> next;

        public Entry(long key2, int hash2) {
            this.key = key2;
            this.origKeyHash = hash2;
        }
    }
}

