/*
 * Decompiled with CFR 0.152.
 */
package org.mapdb;

import java.io.DataInput;
import java.io.IOException;
import org.mapdb.DataInput2;
import org.mapdb.Engine;
import org.mapdb.Serializer;
import org.mapdb.SerializerBase;

public final class Atomic {
    private Atomic() {
    }

    public static final class Var<E> {
        protected final Engine engine;
        protected final long recid;
        protected final Serializer<E> serializer;

        public Var(Engine engine, long recid, Serializer<E> serializer) {
            this.engine = engine;
            this.recid = recid;
            this.serializer = serializer;
        }

        protected Var(Engine engine, SerializerBase serializerBase, DataInput is2, SerializerBase.FastArrayList<Object> objectStack) throws IOException {
            objectStack.add(this);
            this.engine = engine;
            this.recid = DataInput2.unpackLong(is2);
            this.serializer = (Serializer)serializerBase.deserialize(is2, objectStack);
        }

        public long getRecid() {
            return this.recid;
        }

        public java.lang.String toString() {
            E v = this.get();
            return v == null ? null : v.toString();
        }

        public final E get() {
            return this.engine.get(this.recid, this.serializer);
        }

        public final boolean compareAndSet(E expect, E update2) {
            return this.engine.compareAndSwap(this.recid, expect, update2, this.serializer);
        }

        public final void set(E newValue) {
            this.engine.update(this.recid, newValue, this.serializer);
        }

        public final E getAndSet(E newValue) {
            E current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class String {
        protected final Engine engine;
        protected final long recid;

        public String(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public long getRecid() {
            return this.recid;
        }

        public java.lang.String toString() {
            return this.get();
        }

        public final java.lang.String get() {
            return this.engine.get(this.recid, Serializer.STRING_NOSIZE);
        }

        public final boolean compareAndSet(java.lang.String expect, java.lang.String update2) {
            return this.engine.compareAndSwap(this.recid, expect, update2, Serializer.STRING_NOSIZE);
        }

        public final void set(java.lang.String newValue) {
            this.engine.update(this.recid, newValue, Serializer.STRING_NOSIZE);
        }

        public final java.lang.String getAndSet(java.lang.String newValue) {
            java.lang.String current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }
    }

    public static final class Boolean {
        protected final Engine engine;
        protected final long recid;

        public Boolean(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public long getRecid() {
            return this.recid;
        }

        public final boolean get() {
            return this.engine.get(this.recid, Serializer.BOOLEAN);
        }

        public final boolean compareAndSet(boolean expect, boolean update2) {
            return this.engine.compareAndSwap(this.recid, expect, update2, Serializer.BOOLEAN);
        }

        public final void set(boolean newValue) {
            this.engine.update(this.recid, newValue, Serializer.BOOLEAN);
        }

        public final boolean getAndSet(boolean newValue) {
            boolean current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public java.lang.String toString() {
            return java.lang.Boolean.toString(this.get());
        }
    }

    public static final class Long
    extends Number {
        private static final long serialVersionUID = 2882620413591274781L;
        protected final Engine engine;
        protected final long recid;

        public Long(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public long getRecid() {
            return this.recid;
        }

        public final long get() {
            return this.engine.get(this.recid, Serializer.LONG);
        }

        public final void set(long newValue) {
            this.engine.update(this.recid, newValue, Serializer.LONG);
        }

        public final long getAndSet(long newValue) {
            long current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(long expect, long update2) {
            return this.engine.compareAndSwap(this.recid, expect, update2, Serializer.LONG);
        }

        public final long getAndIncrement() {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current + 1L)) {
            }
            return current;
        }

        public final long getAndDecrement() {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current - 1L)) {
            }
            return current;
        }

        public final long getAndAdd(long delta) {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current + delta)) {
            }
            return current;
        }

        public final long incrementAndGet() {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current + 1L)) {
            }
            return next2;
        }

        public final long decrementAndGet() {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current - 1L)) {
            }
            return next2;
        }

        public final long addAndGet(long delta) {
            long next2;
            long current;
            while (!this.compareAndSet(current = this.get(), next2 = current + delta)) {
            }
            return next2;
        }

        public java.lang.String toString() {
            return java.lang.Long.toString(this.get());
        }

        @Override
        public int intValue() {
            return (int)this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }

    public static final class Integer
    extends Number {
        private static final long serialVersionUID = 4615119399830853054L;
        protected final Engine engine;
        protected final long recid;

        public Integer(Engine engine, long recid) {
            this.engine = engine;
            this.recid = recid;
        }

        public long getRecid() {
            return this.recid;
        }

        public final int get() {
            return this.engine.get(this.recid, Serializer.INTEGER);
        }

        public final void set(int newValue) {
            this.engine.update(this.recid, newValue, Serializer.INTEGER);
        }

        public final int getAndSet(int newValue) {
            int current;
            while (!this.compareAndSet(current = this.get(), newValue)) {
            }
            return current;
        }

        public final boolean compareAndSet(int expect, int update2) {
            return this.engine.compareAndSwap(this.recid, expect, update2, Serializer.INTEGER);
        }

        public final int getAndIncrement() {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current + 1)) {
            }
            return current;
        }

        public final int getAndDecrement() {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current - 1)) {
            }
            return current;
        }

        public final int getAndAdd(int delta) {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current + delta)) {
            }
            return current;
        }

        public final int incrementAndGet() {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current + 1)) {
            }
            return next2;
        }

        public final int decrementAndGet() {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current - 1)) {
            }
            return next2;
        }

        public final int addAndGet(int delta) {
            int next2;
            int current;
            while (!this.compareAndSet(current = this.get(), next2 = current + delta)) {
            }
            return next2;
        }

        public java.lang.String toString() {
            return java.lang.Integer.toString(this.get());
        }

        @Override
        public int intValue() {
            return this.get();
        }

        @Override
        public long longValue() {
            return this.get();
        }

        @Override
        public float floatValue() {
            return this.get();
        }

        @Override
        public double doubleValue() {
            return this.get();
        }
    }
}

