/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.util;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.UUID;
import java.util.concurrent.ConcurrentMap;
import org.eclipse.rdf4j.util.UUIDable;

public class NonSerializables {
    private static final Cache<UUID, Object> registry = CacheBuilder.newBuilder().weakValues().build();

    public static final Object get(UUID key2) {
        return registry.getIfPresent(key2);
    }

    public static final UUID getKey(Object obj) {
        ConcurrentMap<UUID, Object> map2 = registry.asMap();
        for (UUID key2 : map2.keySet()) {
            if (obj != map2.get(key2)) continue;
            return key2;
        }
        return null;
    }

    public static final UUID register(Object obj) {
        UUID key2;
        if (obj instanceof UUIDable) {
            key2 = ((UUIDable)obj).getUUID();
            if (NonSerializables.get(key2) == null) {
                registry.put(key2, obj);
            }
        } else {
            key2 = NonSerializables.getKey(obj);
            if (key2 == null) {
                key2 = UUID.randomUUID();
                registry.put(key2, obj);
            }
        }
        return key2;
    }

    private NonSerializables() {
    }
}

