/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function.spif;

import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.SPIF;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.BinaryFunction;

public class DecimalFormat
extends BinaryFunction {
    @Override
    public String getURI() {
        return SPIF.DECIMAL_FORMAT_FUNCTION.toString();
    }

    @Override
    protected Value evaluate(ValueFactory valueFactory, Value arg1, Value arg2) throws ValueExprEvaluationException {
        if (!(arg1 instanceof Literal) || !(arg2 instanceof Literal)) {
            throw new ValueExprEvaluationException("Both arguments must be literals");
        }
        Literal number = (Literal)arg1;
        Literal format2 = (Literal)arg2;
        java.text.DecimalFormat formatter2 = new java.text.DecimalFormat(format2.getLabel());
        String value = XMLSchema.INT.equals(number.getDatatype()) || XMLSchema.LONG.equals(number.getDatatype()) || XMLSchema.SHORT.equals(number.getDatatype()) || XMLSchema.BYTE.equals(number.getDatatype()) ? formatter2.format(number.longValue()) : (XMLSchema.DECIMAL.equals(number.getDatatype()) ? formatter2.format(number.decimalValue()) : (XMLSchema.INTEGER.equals(number.getDatatype()) ? formatter2.format(number.integerValue()) : formatter2.format(number.doubleValue())));
        return valueFactory.createLiteral(value);
    }
}

