/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.spin.function;

import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.BooleanLiteral;
import org.eclipse.rdf4j.model.vocabulary.SPIN;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryPreparer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.Function;
import org.eclipse.rdf4j.query.parser.ParsedBooleanQuery;
import org.eclipse.rdf4j.spin.SpinParser;
import org.eclipse.rdf4j.spin.function.AbstractSpinFunction;

public class AskFunction
extends AbstractSpinFunction
implements Function {
    private SpinParser parser;

    public AskFunction() {
        super(SPIN.ASK_FUNCTION.stringValue());
    }

    public AskFunction(SpinParser parser) {
        this();
        this.parser = parser;
    }

    public SpinParser getSpinParser() {
        return this.parser;
    }

    public void setSpinParser(SpinParser parser) {
        this.parser = parser;
    }

    @Override
    public Value evaluate(ValueFactory valueFactory, Value ... args) throws ValueExprEvaluationException {
        QueryPreparer qp = this.getCurrentQueryPreparer();
        if (args.length == 0 || !(args[0] instanceof Resource)) {
            throw new ValueExprEvaluationException("First argument must be a resource");
        }
        if (args.length % 2 == 0) {
            throw new ValueExprEvaluationException("Old number of arguments required");
        }
        try {
            ParsedBooleanQuery askQuery = this.parser.parseAskQuery((Resource)args[0], qp.getTripleSource());
            BooleanQuery queryOp = qp.prepare(askQuery);
            AskFunction.addBindings(queryOp, args);
            return BooleanLiteral.valueOf(queryOp.evaluate());
        }
        catch (ValueExprEvaluationException e2) {
            throw e2;
        }
        catch (RDF4JException e3) {
            throw new ValueExprEvaluationException(e3);
        }
    }
}

