/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf.btree;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.BitSet;
import org.eclipse.rdf4j.common.io.ByteArrayUtil;
import org.eclipse.rdf4j.common.io.NioFile;
import org.eclipse.rdf4j.sail.nativerdf.btree.BTree;

class AllocatedNodesList
implements Closeable {
    private static final byte[] MAGIC_NUMBER = new byte[]{97, 110, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private static final int HEADER_LENGTH = MAGIC_NUMBER.length + 1;
    private final BTree btree;
    private final NioFile nioFile;
    private BitSet allocatedNodes;
    private boolean needsSync = false;

    public AllocatedNodesList(File allocNodesFile, BTree btree) throws IOException {
        if (allocNodesFile == null) {
            throw new IllegalArgumentException("allocNodesFile must not be null");
        }
        if (btree == null) {
            throw new IllegalArgumentException("btree muts not be null");
        }
        this.nioFile = new NioFile(allocNodesFile);
        this.btree = btree;
    }

    public File getFile() {
        return this.nioFile.getFile();
    }

    @Override
    public synchronized void close() throws IOException {
        this.close(true);
    }

    public synchronized boolean delete() throws IOException {
        this.close(false);
        return this.nioFile.delete();
    }

    public synchronized void close(boolean syncChanges) throws IOException {
        if (syncChanges) {
            this.sync();
        }
        this.allocatedNodes = null;
        this.needsSync = false;
        this.nioFile.close();
    }

    public synchronized void sync() throws IOException {
        if (this.needsSync) {
            BitSet bitSet = this.allocatedNodes;
            int bitSetLength = this.allocatedNodes.length();
            if (bitSetLength < this.allocatedNodes.size()) {
                bitSet = this.allocatedNodes.get(0, bitSetLength);
            }
            byte[] data2 = ByteArrayUtil.toByteArray(bitSet);
            this.nioFile.truncate(HEADER_LENGTH + data2.length);
            this.nioFile.writeBytes(MAGIC_NUMBER, 0L);
            this.nioFile.writeByte((byte)1, MAGIC_NUMBER.length);
            this.nioFile.writeBytes(data2, HEADER_LENGTH);
            this.needsSync = false;
        }
    }

    private void scheduleSync() throws IOException {
        if (!this.needsSync) {
            this.nioFile.truncate(0L);
            this.needsSync = true;
        }
    }

    public synchronized void clear() throws IOException {
        if (this.allocatedNodes != null) {
            this.allocatedNodes.clear();
        } else {
            this.allocatedNodes = new BitSet();
        }
        this.scheduleSync();
    }

    public synchronized int allocateNode() throws IOException {
        this.initAllocatedNodes();
        int newNodeID = this.allocatedNodes.nextClearBit(1);
        this.allocatedNodes.set(newNodeID);
        this.scheduleSync();
        return newNodeID;
    }

    public synchronized void freeNode(int nodeID) throws IOException {
        this.initAllocatedNodes();
        this.allocatedNodes.clear(nodeID);
        this.scheduleSync();
    }

    public synchronized int getMaxNodeID() throws IOException {
        this.initAllocatedNodes();
        return Math.max(0, this.allocatedNodes.length() - 1);
    }

    public synchronized int getNodeCount() throws IOException {
        this.initAllocatedNodes();
        return this.allocatedNodes.cardinality();
    }

    private void initAllocatedNodes() throws IOException {
        if (this.allocatedNodes == null) {
            if (this.nioFile.size() > 0L) {
                this.loadAllocatedNodesInfo();
            } else {
                this.crawlAllocatedNodes();
            }
        }
    }

    private void loadAllocatedNodesInfo() throws IOException {
        byte[] data2;
        if (this.nioFile.size() >= (long)HEADER_LENGTH && Arrays.equals(MAGIC_NUMBER, this.nioFile.readBytes(0L, MAGIC_NUMBER.length))) {
            byte version2 = this.nioFile.readByte(MAGIC_NUMBER.length);
            if (version2 > 1) {
                throw new IOException("Unable to read allocated nodes file; it uses a newer file format");
            }
            if (version2 != 1) {
                throw new IOException("Unable to read allocated nodes file; invalid file format version: " + version2);
            }
            data2 = this.nioFile.readBytes(HEADER_LENGTH, (int)(this.nioFile.size() - (long)HEADER_LENGTH));
        } else {
            data2 = this.nioFile.readBytes(0L, (int)this.nioFile.size());
            this.scheduleSync();
        }
        this.allocatedNodes = ByteArrayUtil.toBitSet(data2);
    }

    private void crawlAllocatedNodes() throws IOException {
        this.allocatedNodes = new BitSet();
        BTree.Node rootNode = this.btree.readRootNode();
        if (rootNode != null) {
            this.crawlAllocatedNodes(rootNode);
        }
        this.scheduleSync();
    }

    private void crawlAllocatedNodes(BTree.Node node2) throws IOException {
        try {
            this.allocatedNodes.set(node2.getID());
            if (!node2.isLeaf()) {
                for (int i = 0; i < node2.getValueCount() + 1; ++i) {
                    this.crawlAllocatedNodes(node2.getChildNode(i));
                }
            }
        }
        finally {
            node2.release();
        }
    }
}

