/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.IOException;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.nativerdf.TripleStore;
import org.eclipse.rdf4j.sail.nativerdf.ValueStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class NativeEvaluationStatistics
extends EvaluationStatistics {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final ValueStore valueStore;
    private final TripleStore tripleStore;

    public NativeEvaluationStatistics(ValueStore valueStore, TripleStore tripleStore) {
        this.valueStore = valueStore;
        this.tripleStore = tripleStore;
    }

    @Override
    protected EvaluationStatistics.CardinalityCalculator createCardinalityCalculator() {
        return new NativeCardinalityCalculator();
    }

    private double cardinality(Resource subj, IRI pred, Value obj, Resource context) throws IOException {
        int subjID = -1;
        if (subj != null && (subjID = this.valueStore.getID(subj)) == -1) {
            return 0.0;
        }
        int predID = -1;
        if (pred != null && (predID = this.valueStore.getID(pred)) == -1) {
            return 0.0;
        }
        int objID = -1;
        if (obj != null && (objID = this.valueStore.getID(obj)) == -1) {
            return 0.0;
        }
        int contextID = -1;
        if (context != null && (contextID = this.valueStore.getID(context)) == -1) {
            return 0.0;
        }
        return this.tripleStore.cardinality(subjID, predID, objID, contextID);
    }

    protected class NativeCardinalityCalculator
    extends EvaluationStatistics.CardinalityCalculator {
        protected NativeCardinalityCalculator() {
        }

        @Override
        protected double getCardinality(StatementPattern sp) {
            try {
                Value pred;
                Value subj = this.getConstantValue(sp.getSubjectVar());
                if (!(subj instanceof Resource)) {
                    subj = null;
                }
                if (!((pred = this.getConstantValue(sp.getPredicateVar())) instanceof IRI)) {
                    pred = null;
                }
                Value obj = this.getConstantValue(sp.getObjectVar());
                Value context = this.getConstantValue(sp.getContextVar());
                if (!(context instanceof Resource)) {
                    context = null;
                }
                return NativeEvaluationStatistics.this.cardinality((Resource)subj, (IRI)pred, obj, (Resource)context);
            }
            catch (IOException e2) {
                NativeEvaluationStatistics.this.log.error("Failed to estimate statement pattern cardinality, falling back to generic implementation", e2);
                return super.getCardinality(sp);
            }
        }

        protected Value getConstantValue(Var var) {
            return var != null ? var.getValue() : null;
        }
    }
}

