/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.nativerdf;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.common.io.IOUtil;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;

class NamespaceStore
implements Iterable<SimpleNamespace> {
    private static final String FILE_NAME = "namespaces.dat";
    private static final byte[] MAGIC_NUMBER = new byte[]{110, 110, 102};
    private static final byte FILE_FORMAT_VERSION = 1;
    private final File file;
    private final Map<String, SimpleNamespace> namespacesMap;
    private volatile boolean contentsChanged;

    public NamespaceStore(File dataDir) throws IOException {
        this.file = new File(dataDir, FILE_NAME);
        this.namespacesMap = new LinkedHashMap<String, SimpleNamespace>(16);
        if (this.file.exists()) {
            this.readNamespacesFromFile();
        } else {
            this.writeNamespacesToFile();
        }
        this.contentsChanged = false;
    }

    public String getNamespace(String prefix) {
        String result = null;
        SimpleNamespace namespace2 = this.namespacesMap.get(prefix);
        if (namespace2 != null) {
            result = namespace2.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name2) {
        SimpleNamespace ns2 = this.namespacesMap.get(prefix);
        if (ns2 != null) {
            if (!ns2.getName().equals(name2)) {
                ns2.setName(name2);
                this.contentsChanged = true;
            }
        } else {
            this.namespacesMap.put(prefix, new SimpleNamespace(prefix, name2));
            this.contentsChanged = true;
        }
    }

    public void removeNamespace(String prefix) {
        SimpleNamespace ns2 = this.namespacesMap.remove(prefix);
        if (ns2 != null) {
            this.contentsChanged = true;
        }
    }

    @Override
    public Iterator<SimpleNamespace> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        if (!this.namespacesMap.isEmpty()) {
            this.namespacesMap.clear();
            this.contentsChanged = true;
        }
    }

    public void sync() throws IOException {
        if (this.contentsChanged) {
            this.writeNamespacesToFile();
            this.contentsChanged = false;
        }
    }

    public void close() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeNamespacesToFile() throws IOException {
        File file2 = this.file;
        synchronized (file2) {
            try (DataOutputStream out = new DataOutputStream(new FileOutputStream(this.file));){
                out.write(MAGIC_NUMBER);
                out.writeByte(1);
                for (Namespace namespace2 : this.namespacesMap.values()) {
                    out.writeUTF(namespace2.getName());
                    out.writeUTF(namespace2.getPrefix());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readNamespacesFromFile() throws IOException {
        File file2 = this.file;
        synchronized (file2) {
            DataInputStream in = new DataInputStream(new FileInputStream(this.file));
            try {
                byte[] magicNumber = IOUtil.readBytes((InputStream)in, MAGIC_NUMBER.length);
                if (!Arrays.equals(magicNumber, MAGIC_NUMBER)) {
                    throw new IOException("File doesn't contain compatible namespace data");
                }
                byte version2 = in.readByte();
                if (version2 > 1) {
                    throw new IOException("Unable to read namespace file; it uses a newer file format");
                }
                if (version2 != 1) {
                    throw new IOException("Unable to read namespace file; invalid file format version: " + version2);
                }
                try {
                    while (true) {
                        String name2 = in.readUTF();
                        String prefix = in.readUTF();
                        SimpleNamespace ns2 = new SimpleNamespace(prefix, name2);
                        this.namespacesMap.put(prefix, ns2);
                    }
                }
                catch (EOFException e2) {
                    in.close();
                }
            }
            catch (Throwable throwable) {
                in.close();
                throw throwable;
            }
        }
    }

    public static void main(String[] args) throws Exception {
        NamespaceStore nsStore = new NamespaceStore(new File(args[0]));
        for (Namespace ns2 : nsStore) {
            System.out.println(ns2.getPrefix() + " = " + ns2.getName());
        }
    }
}

