/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory.model;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.sail.memory.model.MemResource;
import org.eclipse.rdf4j.sail.memory.model.MemStatement;
import org.eclipse.rdf4j.sail.memory.model.MemStatementList;

public class MemIRI
implements IRI,
MemResource {
    private static final long serialVersionUID = 9118488004995852467L;
    private final String namespace;
    private final String localName;
    private final transient Object creator;
    private int hashCode = 0;
    private volatile transient MemStatementList subjectStatements = null;
    private volatile transient MemStatementList predicateStatements = null;
    private volatile transient MemStatementList objectStatements = null;
    private volatile transient MemStatementList contextStatements = null;

    public MemIRI(Object creator, String namespace2, String localName) {
        this.creator = creator;
        this.namespace = namespace2;
        this.localName = localName;
    }

    @Override
    public String toString() {
        return this.namespace + this.localName;
    }

    @Override
    public String stringValue() {
        return this.toString();
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    @Override
    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof MemIRI) {
            MemIRI o = (MemIRI)other;
            return this.namespace.equals(o.getNamespace()) && this.localName.equals(o.getLocalName());
        }
        if (other instanceof IRI) {
            String otherStr = other.toString();
            return this.namespace.length() + this.localName.length() == otherStr.length() && otherStr.endsWith(this.localName) && otherStr.startsWith(this.namespace);
        }
        return false;
    }

    @Override
    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.toString().hashCode();
        }
        return this.hashCode;
    }

    @Override
    public Object getCreator() {
        return this.creator;
    }

    @Override
    public boolean hasStatements() {
        return this.subjectStatements != null || this.predicateStatements != null || this.objectStatements != null || this.contextStatements != null;
    }

    @Override
    public MemStatementList getSubjectStatementList() {
        if (this.subjectStatements == null) {
            return EMPTY_LIST;
        }
        return this.subjectStatements;
    }

    @Override
    public int getSubjectStatementCount() {
        if (this.subjectStatements == null) {
            return 0;
        }
        return this.subjectStatements.size();
    }

    @Override
    public void addSubjectStatement(MemStatement st) {
        if (this.subjectStatements == null) {
            this.subjectStatements = new MemStatementList(4);
        }
        this.subjectStatements.add(st);
    }

    @Override
    public void removeSubjectStatement(MemStatement st) {
        this.subjectStatements.remove(st);
        if (this.subjectStatements.isEmpty()) {
            this.subjectStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromSubjectStatements(int currentSnapshot) {
        if (this.subjectStatements != null) {
            this.subjectStatements.cleanSnapshots(currentSnapshot);
            if (this.subjectStatements.isEmpty()) {
                this.subjectStatements = null;
            }
        }
    }

    public MemStatementList getPredicateStatementList() {
        if (this.predicateStatements == null) {
            return EMPTY_LIST;
        }
        return this.predicateStatements;
    }

    public int getPredicateStatementCount() {
        if (this.predicateStatements == null) {
            return 0;
        }
        return this.predicateStatements.size();
    }

    public void addPredicateStatement(MemStatement st) {
        if (this.predicateStatements == null) {
            this.predicateStatements = new MemStatementList(4);
        }
        this.predicateStatements.add(st);
    }

    public void removePredicateStatement(MemStatement st) {
        this.predicateStatements.remove(st);
        if (this.predicateStatements.isEmpty()) {
            this.predicateStatements = null;
        }
    }

    public void cleanSnapshotsFromPredicateStatements(int currentSnapshot) {
        if (this.predicateStatements != null) {
            this.predicateStatements.cleanSnapshots(currentSnapshot);
            if (this.predicateStatements.isEmpty()) {
                this.predicateStatements = null;
            }
        }
    }

    @Override
    public MemStatementList getObjectStatementList() {
        if (this.objectStatements == null) {
            return EMPTY_LIST;
        }
        return this.objectStatements;
    }

    @Override
    public int getObjectStatementCount() {
        if (this.objectStatements == null) {
            return 0;
        }
        return this.objectStatements.size();
    }

    @Override
    public void addObjectStatement(MemStatement st) {
        if (this.objectStatements == null) {
            this.objectStatements = new MemStatementList(4);
        }
        this.objectStatements.add(st);
    }

    @Override
    public void removeObjectStatement(MemStatement st) {
        this.objectStatements.remove(st);
        if (this.objectStatements.isEmpty()) {
            this.objectStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromObjectStatements(int currentSnapshot) {
        if (this.objectStatements != null) {
            this.objectStatements.cleanSnapshots(currentSnapshot);
            if (this.objectStatements.isEmpty()) {
                this.objectStatements = null;
            }
        }
    }

    @Override
    public MemStatementList getContextStatementList() {
        if (this.contextStatements == null) {
            return EMPTY_LIST;
        }
        return this.contextStatements;
    }

    @Override
    public int getContextStatementCount() {
        if (this.contextStatements == null) {
            return 0;
        }
        return this.contextStatements.size();
    }

    @Override
    public void addContextStatement(MemStatement st) {
        if (this.contextStatements == null) {
            this.contextStatements = new MemStatementList(4);
        }
        this.contextStatements.add(st);
    }

    @Override
    public void removeContextStatement(MemStatement st) {
        this.contextStatements.remove(st);
        if (this.contextStatements.isEmpty()) {
            this.contextStatements = null;
        }
    }

    @Override
    public void cleanSnapshotsFromContextStatements(int currentSnapshot) {
        if (this.contextStatements != null) {
            this.contextStatements.cleanSnapshots(currentSnapshot);
            if (this.contextStatements.isEmpty()) {
                this.contextStatements = null;
            }
        }
    }
}

