/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.memory;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.rdf4j.model.impl.SimpleNamespace;

class MemNamespaceStore
implements Iterable<SimpleNamespace> {
    private final Map<String, SimpleNamespace> namespacesMap = new LinkedHashMap<String, SimpleNamespace>(16);

    MemNamespaceStore() {
    }

    public String getNamespace(String prefix) {
        String result = null;
        SimpleNamespace namespace2 = this.namespacesMap.get(prefix);
        if (namespace2 != null) {
            result = namespace2.getName();
        }
        return result;
    }

    public void setNamespace(String prefix, String name2) {
        SimpleNamespace ns2 = this.namespacesMap.get(prefix);
        if (ns2 != null) {
            ns2.setName(name2);
        } else {
            this.namespacesMap.put(prefix, new SimpleNamespace(prefix, name2));
        }
    }

    public void removeNamespace(String prefix) {
        this.namespacesMap.remove(prefix);
    }

    @Override
    public Iterator<SimpleNamespace> iterator() {
        return this.namespacesMap.values().iterator();
    }

    public void clear() {
        this.namespacesMap.clear();
    }
}

