/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;

class PropertyCache {
    private final SearchDocument doc;
    private Map<String, Set<String>> cachedProperties;

    PropertyCache(SearchDocument doc2) {
        this.doc = doc2;
    }

    boolean hasProperty(String name2, String value) {
        boolean found;
        Set<String> cachedValues = this.getCachedValues(name2);
        if (cachedValues != null) {
            found = cachedValues.contains(value);
        } else {
            found = false;
            List<String> docValues = this.doc.getProperty(name2);
            if (docValues != null) {
                cachedValues = new HashSet<String>(docValues.size());
                for (String docValue : docValues) {
                    cachedValues.add(docValue);
                    if (!docValue.equals(value)) continue;
                    found = true;
                }
            } else {
                cachedValues = Collections.emptySet();
            }
            this.setCachedValues(name2, cachedValues);
        }
        return found;
    }

    private Set<String> getCachedValues(String name2) {
        return this.cachedProperties != null ? this.cachedProperties.get(name2) : null;
    }

    private void setCachedValues(String name2, Set<String> values) {
        if (this.cachedProperties == null) {
            this.cachedProperties = new HashMap<String, Set<String>>();
        }
        this.cachedProperties.put(name2, values);
    }
}

