/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import com.google.common.base.Function;
import com.spatial4j.core.shape.Shape;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.spatial.SpatialStrategy;
import org.eclipse.rdf4j.sail.lucene.LuceneIndex;
import org.eclipse.rdf4j.sail.lucene.SearchDocument;
import org.eclipse.rdf4j.sail.lucene.SearchFields;

public class LuceneDocument
implements SearchDocument {
    private final Document doc;
    private final Function<? super String, ? extends SpatialStrategy> geoStrategyMapper;

    @Deprecated
    public LuceneDocument() {
        this(null);
    }

    public LuceneDocument(Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this(new Document(), geoStrategyMapper);
    }

    public LuceneDocument(Document doc2, Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this.doc = doc2;
        this.geoStrategyMapper = geoStrategyMapper;
    }

    public LuceneDocument(String id, String resourceId, String context, Function<? super String, ? extends SpatialStrategy> geoStrategyMapper) {
        this(geoStrategyMapper);
        this.setId(id);
        this.setResource(resourceId);
        this.setContext(context);
    }

    private void setId(String id) {
        LuceneIndex.addIDField(id, this.doc);
    }

    private void setContext(String context) {
        LuceneIndex.addContextField(context, this.doc);
    }

    private void setResource(String resourceId) {
        LuceneIndex.addResourceField(resourceId, this.doc);
    }

    public Document getDocument() {
        return this.doc;
    }

    @Override
    public String getId() {
        return this.doc.get("id");
    }

    @Override
    public String getResource() {
        return this.doc.get("uri");
    }

    @Override
    public String getContext() {
        return this.doc.get("context");
    }

    public Set<String> getPropertyNames() {
        List<IndexableField> fields = this.doc.getFields();
        HashSet<String> names = new HashSet<String>();
        for (IndexableField field : fields) {
            String name2 = field.name();
            if (!SearchFields.isPropertyField(name2)) continue;
            names.add(name2);
        }
        return names;
    }

    @Override
    public void addProperty(String name2) {
    }

    @Override
    public void addProperty(String name2, String text) {
        LuceneIndex.addPredicateField(name2, text, this.doc);
        LuceneIndex.addTextField(text, this.doc);
    }

    @Override
    public boolean hasProperty(String fieldName, String value) {
        String[] fields = this.doc.getValues(fieldName);
        if (fields != null) {
            for (String field : fields) {
                if (!value.equals(field)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<String> getProperty(String name2) {
        return Arrays.asList(this.doc.getValues(name2));
    }

    @Override
    public void addGeoProperty(String field, String value) {
        LuceneIndex.addStoredOnlyPredicateField(field, value, this.doc);
        try {
            SpatialStrategy geoStrategy = this.geoStrategyMapper.apply(field);
            Shape shape = geoStrategy.getSpatialContext().readShapeFromWkt(value);
            for (Field f : geoStrategy.createIndexableFields(shape)) {
                this.doc.add(f);
            }
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }
}

