/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.lucene;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.vocabulary.GEOF;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.TupleFunctionCall;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.lucene.DistanceQuerySpec;
import org.eclipse.rdf4j.sail.lucene.LuceneSailSchema;
import org.eclipse.rdf4j.sail.lucene.SearchFields;
import org.eclipse.rdf4j.sail.lucene.SearchIndex;
import org.eclipse.rdf4j.sail.lucene.SearchQueryEvaluator;
import org.eclipse.rdf4j.sail.lucene.SearchQueryInterpreter;

public class DistanceQuerySpecBuilder
implements SearchQueryInterpreter {
    private SearchIndex index;

    public DistanceQuerySpecBuilder(SearchIndex index2) {
        this.index = index2;
    }

    @Override
    public void process(TupleExpr tupleExpr, BindingSet bindings, final Collection<SearchQueryEvaluator> results) throws SailException {
        tupleExpr.visit(new AbstractQueryModelVisitor<SailException>(){
            final Map<String, DistanceQuerySpec> specs = new HashMap<String, DistanceQuerySpec>();

            @Override
            public void meet(FunctionCall f) throws SailException {
                if (GEOF.DISTANCE.stringValue().equals(f.getURI())) {
                    List<ValueExpr> args = f.getArgs();
                    if (args.size() != 3) {
                        return;
                    }
                    Filter filter2 = null;
                    ValueExpr dist = null;
                    String distanceVar = null;
                    QueryModelNode parent = f.getParentNode();
                    if (parent instanceof ExtensionElem) {
                        distanceVar = ((ExtensionElem)parent).getName();
                        QueryModelNode extension = parent.getParentNode();
                        Object[] rv = DistanceQuerySpecBuilder.getFilterAndDistance(extension.getParentNode(), distanceVar);
                        if (rv == null) {
                            return;
                        }
                        filter2 = (Filter)rv[0];
                        dist = (ValueExpr)rv[1];
                    } else if (parent instanceof Compare) {
                        filter2 = (Filter)parent.getParentNode();
                        Compare compare2 = (Compare)parent;
                        Compare.CompareOp op = compare2.getOperator();
                        if (op == Compare.CompareOp.LT && compare2.getLeftArg() == f) {
                            dist = compare2.getRightArg();
                        } else if (op == Compare.CompareOp.GT && compare2.getRightArg() == f) {
                            dist = compare2.getLeftArg();
                        }
                    }
                    DistanceQuerySpec spec = new DistanceQuerySpec(f, dist, distanceVar, filter2);
                    this.specs.put(spec.getGeoVar(), spec);
                }
            }

            @Override
            public void meet(StatementPattern sp) {
                String objectVarName;
                DistanceQuerySpec spec;
                IRI propertyName = (IRI)sp.getPredicateVar().getValue();
                if (propertyName != null && DistanceQuerySpecBuilder.this.index.isGeoField(SearchFields.getPropertyField(propertyName)) && !sp.getObjectVar().hasValue() && (spec = this.specs.remove(objectVarName = sp.getObjectVar().getName())) != null && DistanceQuerySpecBuilder.isChildOf(sp, spec.getFilter())) {
                    spec.setGeometryPattern(sp);
                    if (spec.isEvaluable()) {
                        results.add(spec);
                    } else {
                        TupleFunctionCall funcCall = new TupleFunctionCall();
                        funcCall.setURI(LuceneSailSchema.WITHIN_DISTANCE.toString());
                        FunctionCall df = spec.getDistanceFunctionCall();
                        List<ValueExpr> dfArgs = df.getArgs();
                        funcCall.addArg(dfArgs.get(0));
                        funcCall.addArg(spec.getDistanceExpr());
                        funcCall.addArg(dfArgs.get(2));
                        funcCall.addArg(new ValueConstant(spec.getGeoProperty()));
                        funcCall.addResultVar(sp.getSubjectVar());
                        funcCall.addResultVar(sp.getObjectVar());
                        if (spec.getDistanceVar() != null) {
                            funcCall.addArg(new ValueConstant(LuceneSailSchema.DISTANCE));
                            funcCall.addResultVar(new Var(spec.getDistanceVar()));
                        }
                        if (spec.getContextVar() != null) {
                            Resource context = (Resource)spec.getContextVar().getValue();
                            if (context != null) {
                                funcCall.addArg(new ValueConstant(context));
                            } else {
                                funcCall.addArg(new ValueConstant(LuceneSailSchema.CONTEXT));
                                funcCall.addResultVar(spec.getContextVar());
                            }
                        }
                        Join join2 = new Join();
                        sp.replaceWith(join2);
                        join2.setLeftArg(sp);
                        join2.setRightArg(funcCall);
                        spec.updateQueryModelNodes(true);
                    }
                }
            }
        });
    }

    private static boolean isChildOf(QueryModelNode child, QueryModelNode parent) {
        if (child.getParentNode() == parent) {
            return true;
        }
        return DistanceQuerySpecBuilder.isChildOf(child.getParentNode(), parent);
    }

    private static Object[] getFilterAndDistance(QueryModelNode node2, String compareArgVarName) {
        Object[] rv = null;
        if (node2 instanceof Filter) {
            Filter f = (Filter)node2;
            ValueExpr condition = f.getCondition();
            if (condition instanceof Compare) {
                Compare compare2 = (Compare)condition;
                Compare.CompareOp op = compare2.getOperator();
                ValueExpr dist = null;
                if (op == Compare.CompareOp.LT && compareArgVarName.equals(DistanceQuerySpec.getVarName(compare2.getLeftArg()))) {
                    dist = compare2.getRightArg();
                } else if (op == Compare.CompareOp.GT && compareArgVarName.equals(DistanceQuerySpec.getVarName(compare2.getRightArg()))) {
                    dist = compare2.getLeftArg();
                }
                rv = new Object[]{f, dist};
            }
        } else if (node2 != null) {
            rv = DistanceQuerySpecBuilder.getFilterAndDistance(node2.getParentNode(), compareArgVarName);
        }
        return rv;
    }
}

