/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.federation.optimizers;

import com.google.common.base.MoreObjects;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.filters.AccurateRepositoryBloomFilter;
import org.eclipse.rdf4j.repository.filters.RepositoryBloomFilter;
import org.eclipse.rdf4j.sail.federation.PrefixHashSet;
import org.eclipse.rdf4j.sail.federation.algebra.AbstractNaryOperator;
import org.eclipse.rdf4j.sail.federation.algebra.NaryJoin;
import org.eclipse.rdf4j.sail.federation.algebra.OwnedTupleExpr;

public class FederationJoinOptimizer
extends AbstractQueryModelVisitor<RepositoryException>
implements QueryOptimizer {
    private final Collection<? extends RepositoryConnection> members;
    private final Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters;
    private Map<Resource, List<RepositoryConnection>> contextToMemberMap;
    private final PrefixHashSet localSpace;
    private final boolean distinct;
    private Dataset dataset;

    public FederationJoinOptimizer(Collection<? extends RepositoryConnection> members, boolean distinct2, PrefixHashSet localSpace) {
        this(members, distinct2, localSpace, c -> AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
    }

    public FederationJoinOptimizer(Collection<? extends RepositoryConnection> members, boolean distinct2, PrefixHashSet localSpace, Function<? super Repository, ? extends RepositoryBloomFilter> bloomFilters) {
        this.members = members;
        this.localSpace = localSpace;
        this.bloomFilters = bloomFilters;
        this.distinct = distinct2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<Resource, List<RepositoryConnection>> createContextToMemberMap(Collection<? extends RepositoryConnection> members) throws RepositoryException {
        HashMap<Resource, List<RepositoryConnection>> contextToMemberMap = new HashMap<Resource, List<RepositoryConnection>>(members.size() + 1);
        for (RepositoryConnection repositoryConnection : members) {
            try (RepositoryResult<Resource> res = repositoryConnection.getContextIDs();){
                while (res.hasNext()) {
                    Resource ctx = res.next();
                    ArrayList<RepositoryConnection> contextMembers = (ArrayList<RepositoryConnection>)contextToMemberMap.get(ctx);
                    if (contextMembers == null) {
                        contextMembers = new ArrayList<RepositoryConnection>();
                        contextToMemberMap.put(ctx, contextMembers);
                    }
                    contextMembers.add(repositoryConnection);
                }
            }
        }
        return contextToMemberMap;
    }

    @Override
    public void optimize(TupleExpr query, Dataset dataset, BindingSet bindings) {
        this.dataset = dataset;
        try {
            query.visit(this);
        }
        catch (RepositoryException e2) {
            throw new UndeclaredThrowableException(e2);
        }
        finally {
            this.dataset = null;
        }
    }

    @Override
    public void meetOther(QueryModelNode node2) throws RepositoryException {
        if (node2 instanceof NaryJoin) {
            this.meetMultiJoin((NaryJoin)node2);
        } else {
            super.meetOther(node2);
        }
    }

    public void meetMultiJoin(NaryJoin node2) throws RepositoryException {
        super.meetOther(node2);
        ArrayList<Owned<NaryJoin>> ows = new ArrayList<Owned<NaryJoin>>();
        ArrayList<LocalJoin> vars = new ArrayList<LocalJoin>();
        for (TupleExpr arg : node2.getArgs()) {
            RepositoryConnection member = this.getSingleOwner(arg);
            if (!ows.isEmpty() && ((Owned)ows.get(ows.size() - 1)).getOwner() == member) {
                ((NaryJoin)((Owned)ows.get(ows.size() - 1)).getOperation()).addArg(arg.clone());
                continue;
            }
            ows.add(new Owned<NaryJoin>(member, new NaryJoin(arg.clone())));
        }
        for (TupleExpr arg : node2.getArgs()) {
            Var subj = this.getLocalSubject(arg);
            LocalJoin local = this.findLocalJoin(subj, vars);
            if (local == null) {
                vars.add(new LocalJoin(subj, new NaryJoin(arg.clone())));
                continue;
            }
            local.getJoin().addArg(arg.clone());
        }
        this.addOwners(node2, ows, vars);
    }

    @Override
    public void meet(LeftJoin node2) throws RepositoryException {
        super.meet(node2);
        Var leftSubject = this.getLocalSubject(node2.getLeftArg());
        Var rightSubject = this.getLocalSubject(node2.getRightArg());
        boolean local = leftSubject != null && leftSubject.equals(rightSubject);
        RepositoryConnection leftOwner = this.getSingleOwner(node2.getLeftArg());
        RepositoryConnection rightOwner = this.getSingleOwner(node2.getRightArg());
        this.addOwners(node2, leftOwner, rightOwner, local);
    }

    @Override
    public void meet(Union node2) throws RepositoryException {
        super.meet(node2);
        ArrayList<Owned<TupleExpr>> ows = new ArrayList<Owned<TupleExpr>>();
        for (TupleExpr arg : new TupleExpr[]{node2.getLeftArg(), node2.getRightArg()}) {
            RepositoryConnection member = this.getSingleOwner(arg);
            int idx = ows.size() - 1;
            if (!ows.isEmpty() && ((Owned)ows.get(idx)).getOwner() == member) {
                TupleExpr union2 = (TupleExpr)((Owned)ows.get(idx)).getOperation();
                union2 = new Union(union2, arg.clone());
                ((Owned)ows.get(idx)).setOperation(union2);
                continue;
            }
            ows.add(new Owned<TupleExpr>(member, arg.clone()));
        }
        this.addOwners(node2, ows);
    }

    @Override
    protected void meetUnaryTupleOperator(UnaryTupleOperator node2) throws RepositoryException {
        super.meetUnaryTupleOperator(node2);
        RepositoryConnection owner = this.getSingleOwner(node2.getArg());
        if (owner != null) {
            node2.replaceWith(new OwnedTupleExpr(owner, node2.clone()));
        }
    }

    private LocalJoin findLocalJoin(Var subj, List<LocalJoin> vars) {
        LocalJoin result = null;
        if (!vars.isEmpty() && vars.get(vars.size() - 1).getVar() == subj) {
            result = vars.get(vars.size() - 1);
        } else {
            for (LocalJoin local : vars) {
                if (subj == null || !subj.equals(local.getVar())) continue;
                result = local;
                break;
            }
        }
        return result;
    }

    private RepositoryConnection getSingleOwner(TupleExpr arg) throws RepositoryException {
        return new OwnerScanner().getSingleOwner(arg);
    }

    private Var getLocalSubject(TupleExpr arg) throws RepositoryException {
        return new LocalScanner().getLocalSubject(arg);
    }

    private void addOwners(NaryJoin node2, List<Owned<NaryJoin>> ows, List<LocalJoin> vars) throws RepositoryException {
        boolean local = this.isLocal(vars);
        if (ows.size() == 1) {
            RepositoryConnection owner = ows.get(0).getOwner();
            if (owner == null) {
                if (local) {
                    this.performReplacementsInNode(node2, vars);
                }
            } else {
                node2.replaceWith(new OwnedTupleExpr(owner, node2.clone()));
            }
        } else if (local) {
            AbstractQueryModelNode replacement = new NaryJoin();
            for (LocalJoin v : vars) {
                Var var = v.getVar();
                NaryJoin join2 = v.getJoin();
                if (var == null) {
                    for (TupleExpr expr : join2.getArgs()) {
                        ((AbstractNaryOperator)replacement).addArg(expr);
                    }
                    continue;
                }
                replacement = this.optimizeReplacementJoin(replacement, join2);
            }
            node2.replaceWith(replacement);
        } else {
            NaryJoin replacement = this.generateReplacementFromOwnedJoins(ows);
            node2.replaceWith(replacement);
        }
    }

    private NaryJoin generateReplacementFromOwnedJoins(List<Owned<NaryJoin>> ows) {
        NaryJoin replacement = new NaryJoin();
        for (Owned<NaryJoin> e2 : ows) {
            RepositoryConnection owner = e2.getOwner();
            NaryJoin join2 = e2.getOperation();
            if (owner == null) {
                for (TupleExpr arg : join2.getArgs()) {
                    replacement.addArg(arg);
                }
                continue;
            }
            replacement.addArg(new OwnedTupleExpr(owner, join2));
        }
        return replacement;
    }

    private AbstractQueryModelNode optimizeReplacementJoin(AbstractQueryModelNode candidate, NaryJoin join2) throws RepositoryException {
        boolean multipleOwners = false;
        RepositoryConnection owner = null;
        for (TupleExpr expr : join2.getArgs()) {
            RepositoryConnection connection = this.getSingleOwner(expr);
            if (owner == null) {
                owner = connection;
                continue;
            }
            if (connection == null || owner == connection) continue;
            multipleOwners = true;
            owner = null;
            break;
        }
        AbstractQueryModelNode replacement = candidate;
        if (multipleOwners) {
            replacement = new EmptySet();
        } else if (owner == null) {
            this.addUnionOfMembers((NaryJoin)replacement, join2);
        } else {
            this.addArg((NaryJoin)replacement, new OwnedTupleExpr(owner, join2));
        }
        return replacement;
    }

    private void addUnionOfMembers(NaryJoin replacement, NaryJoin join2) {
        AbstractQueryModelNode union2 = null;
        for (RepositoryConnection repositoryConnection : this.members) {
            OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, join2.clone());
            union2 = union2 == null ? arg : new Union((TupleExpr)((Object)union2), arg);
        }
        if (union2 != null) {
            replacement.addArg(union2);
        }
    }

    private void performReplacementsInNode(NaryJoin node2, List<LocalJoin> vars) {
        NaryJoin replacement = new NaryJoin();
        for (LocalJoin e2 : vars) {
            if (this.distinct || e2.getVar() != null) {
                AbstractQueryModelNode union2 = null;
                for (RepositoryConnection repositoryConnection : this.members) {
                    OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, e2.getJoin().clone());
                    union2 = union2 == null ? arg : new Union((TupleExpr)((Object)union2), arg);
                }
                if (union2 == null) continue;
                replacement.addArg(union2);
                continue;
            }
            for (TupleExpr expr : e2.getJoin().getArgs()) {
                replacement.addArg(expr);
            }
        }
        node2.replaceWith(replacement);
    }

    private boolean isLocal(List<LocalJoin> vars) {
        boolean local = false;
        if (vars.size() > 1 || vars.size() == 1 && vars.get(0).getVar() != null) {
            for (LocalJoin e2 : vars) {
                if (e2.getVar() == null || e2.getJoin().getNumberOfArguments() <= 1) continue;
                local = true;
                break;
            }
        }
        return local;
    }

    private void addArg(NaryJoin destination, OwnedTupleExpr newArg) {
        TupleExpr expr;
        boolean found = false;
        int size = destination.getNumberOfArguments();
        if (size > 0 && (expr = (TupleExpr)destination.getArg(size - 1)) instanceof OwnedTupleExpr) {
            boolean sameOwner;
            OwnedTupleExpr existing = (OwnedTupleExpr)expr;
            boolean bl = sameOwner = newArg.getOwner() == existing.getOwner();
            if (sameOwner && existing.getArg() instanceof NaryJoin) {
                NaryJoin existingJoin = (NaryJoin)existing.getArg();
                NaryJoin newJoin = (NaryJoin)newArg.getArg();
                for (TupleExpr t : newJoin.getArgs()) {
                    existingJoin.addArg(t);
                }
                found = true;
            }
        }
        if (!found) {
            destination.addArg(newArg);
        }
    }

    private void addOwners(LeftJoin node2, RepositoryConnection leftOwner, RepositoryConnection rightOwner, boolean local) {
        if (leftOwner == null && rightOwner == null) {
            if (local) {
                AbstractQueryModelNode union2 = null;
                for (RepositoryConnection repositoryConnection : this.members) {
                    OwnedTupleExpr arg = new OwnedTupleExpr(repositoryConnection, node2.clone());
                    union2 = union2 == null ? arg : new Union((TupleExpr)((Object)union2), arg);
                }
                node2.replaceWith(union2);
            }
        } else if (leftOwner == rightOwner) {
            node2.replaceWith(new OwnedTupleExpr(leftOwner, node2.clone()));
        } else if (local) {
            this.addDistinctOwnersLocal(node2, leftOwner, rightOwner);
        } else {
            this.addDistinctOwnersNonLocal(node2, leftOwner, rightOwner);
        }
    }

    private void addDistinctOwnersNonLocal(LeftJoin node2, RepositoryConnection leftOwner, RepositoryConnection rightOwner) {
        if (leftOwner != null) {
            node2.getLeftArg().replaceWith(new OwnedTupleExpr(leftOwner, node2.getLeftArg().clone()));
        }
        if (rightOwner != null) {
            node2.getRightArg().replaceWith(new OwnedTupleExpr(rightOwner, node2.getRightArg().clone()));
        }
    }

    private void addDistinctOwnersLocal(LeftJoin node2, RepositoryConnection leftOwner, RepositoryConnection rightOwner) {
        if (rightOwner == null) {
            node2.replaceWith(new OwnedTupleExpr(leftOwner, node2.clone()));
        } else if (leftOwner == null) {
            AbstractQueryModelNode union2 = null;
            for (RepositoryConnection repositoryConnection : this.members) {
                OwnedTupleExpr arg;
                if (rightOwner == repositoryConnection) {
                    arg = new OwnedTupleExpr(repositoryConnection, node2.clone());
                    union2 = union2 == null ? arg : new Union((TupleExpr)((Object)union2), arg);
                    continue;
                }
                arg = new OwnedTupleExpr(repositoryConnection, node2.getLeftArg().clone());
                union2 = union2 == null ? arg : new Union((TupleExpr)((Object)union2), arg);
            }
            node2.replaceWith(union2);
        } else {
            node2.replaceWith(new OwnedTupleExpr(leftOwner, node2.getLeftArg().clone()));
        }
    }

    private void addOwners(Union node2, List<Owned<TupleExpr>> ows) {
        if (ows.size() == 1) {
            RepositoryConnection owner = ows.get(0).getOwner();
            if (owner != null) {
                node2.replaceWith(new OwnedTupleExpr(owner, node2.clone()));
            }
        } else {
            TupleExpr replacement = null;
            for (Owned<TupleExpr> e2 : ows) {
                RepositoryConnection owner = e2.getOwner();
                TupleExpr union2 = e2.getOperation();
                if (owner == null) {
                    for (TupleExpr arg : this.getUnionArgs(union2)) {
                        replacement = replacement == null ? arg.clone() : new Union(replacement, arg.clone());
                    }
                    continue;
                }
                OwnedTupleExpr arg = new OwnedTupleExpr(owner, union2);
                replacement = replacement == null ? arg : new Union(replacement, arg);
            }
            node2.replaceWith(replacement);
        }
    }

    private List<TupleExpr> getUnionArgs(TupleExpr union2) {
        return this.getUnionArgs(union2, new ArrayList<TupleExpr>());
    }

    private List<TupleExpr> getUnionArgs(TupleExpr union2, List<TupleExpr> list) {
        if (union2 instanceof Union) {
            this.getUnionArgs(((Union)union2).getLeftArg(), list);
            this.getUnionArgs(((Union)union2).getRightArg(), list);
        } else {
            list.add(union2);
        }
        return list;
    }

    private class LocalScanner
    extends AbstractQueryModelVisitor<RepositoryException> {
        private boolean isLocal;
        private Var relative;

        private LocalScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Var getLocalSubject(TupleExpr arg) throws RepositoryException {
            boolean local_stack = this.isLocal;
            Var relative_stack = this.relative;
            try {
                this.isLocal = true;
                this.relative = null;
                arg.visit(this);
                Var var = this.relative;
                return var;
            }
            finally {
                this.isLocal = local_stack;
                this.relative = relative_stack;
            }
        }

        @Override
        public void meet(StatementPattern node2) throws RepositoryException {
            super.meet(node2);
            IRI pred = (IRI)node2.getPredicateVar().getValue();
            if (pred != null && FederationJoinOptimizer.this.localSpace != null && FederationJoinOptimizer.this.localSpace.match(pred.stringValue())) {
                this.local(node2.getSubjectVar());
            } else {
                this.notLocal();
            }
        }

        private void local(Var subj) {
            if (this.isLocal && this.relative == null) {
                this.relative = subj;
            } else if (!subj.equals(this.relative)) {
                this.notLocal();
            }
        }

        private void notLocal() {
            this.isLocal = false;
            this.relative = null;
        }
    }

    private class OwnerScanner
    extends AbstractQueryModelVisitor<RepositoryException> {
        private boolean shared;
        private RepositoryConnection owner;

        private OwnerScanner() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public RepositoryConnection getSingleOwner(TupleExpr arg) throws RepositoryException {
            boolean pre_shared = this.shared;
            RepositoryConnection pre_owner = this.owner;
            try {
                this.shared = false;
                this.owner = null;
                arg.visit(this);
                RepositoryConnection repositoryConnection = this.owner;
                return repositoryConnection;
            }
            finally {
                this.shared = pre_shared;
                this.owner = pre_owner;
            }
        }

        @Override
        public void meet(StatementPattern node2) throws RepositoryException {
            super.meet(node2);
            Resource subj = (Resource)node2.getSubjectVar().getValue();
            IRI pred = (IRI)node2.getPredicateVar().getValue();
            Value obj = node2.getObjectVar().getValue();
            Resource[] ctx = this.getContexts(node2.getContextVar());
            RepositoryConnection member = this.getSingleOwner(subj, pred, obj, ctx);
            if (member == null) {
                this.multipleOwners();
            } else {
                this.usedBy(member);
            }
        }

        @Override
        public void meetOther(QueryModelNode node2) throws RepositoryException {
            if (node2 instanceof OwnedTupleExpr) {
                this.meetOwnedTupleExpr((OwnedTupleExpr)node2);
            } else {
                super.meetOther(node2);
            }
        }

        private void meetOwnedTupleExpr(OwnedTupleExpr node2) throws RepositoryException {
            this.usedBy(node2.getOwner());
        }

        private Resource[] getContexts(Var var) {
            Resource[] resourceArray;
            if (var == null || !var.hasValue()) {
                resourceArray = new Resource[]{};
            } else {
                Resource[] resourceArray2 = new Resource[1];
                resourceArray = resourceArray2;
                resourceArray2[0] = (Resource)var.getValue();
            }
            return resourceArray;
        }

        private RepositoryConnection getSingleOwner(Resource subj, IRI pred, Value obj, Resource[] ctx) throws RepositoryException {
            List<Resource> explicitContexts;
            RepositoryConnection result = null;
            if (FederationJoinOptimizer.this.contextToMemberMap == null) {
                FederationJoinOptimizer.this.contextToMemberMap = FederationJoinOptimizer.createContextToMemberMap(FederationJoinOptimizer.this.members);
            }
            HashSet results = new HashSet();
            if (ctx.length > 0) {
                explicitContexts = Arrays.asList(ctx);
            } else if (FederationJoinOptimizer.this.dataset != null) {
                explicitContexts = new ArrayList<Resource>();
                explicitContexts.addAll(FederationJoinOptimizer.this.dataset.getDefaultGraphs());
                explicitContexts.addAll(FederationJoinOptimizer.this.dataset.getNamedGraphs());
            } else {
                explicitContexts = Collections.emptyList();
            }
            for (Resource context : explicitContexts) {
                List contextRepos = (List)FederationJoinOptimizer.this.contextToMemberMap.get(context);
                if (contextRepos == null) continue;
                results.addAll(contextRepos);
            }
            if (results.size() == 1) {
                result = (RepositoryConnection)results.iterator().next();
            } else {
                for (RepositoryConnection member : results) {
                    RepositoryBloomFilter bloomFilter = MoreObjects.firstNonNull(FederationJoinOptimizer.this.bloomFilters.apply(member.getRepository()), AccurateRepositoryBloomFilter.INCLUDE_INFERRED_INSTANCE);
                    if (!bloomFilter.mayHaveStatement(member, subj, pred, obj, ctx)) continue;
                    if (result == null) {
                        result = member;
                        continue;
                    }
                    if (result == member) continue;
                    result = null;
                    break;
                }
            }
            return result;
        }

        private void usedBy(RepositoryConnection member) {
            if (!this.shared && this.owner == null) {
                this.owner = member;
            } else if (this.owner != member) {
                this.multipleOwners();
            }
        }

        private void multipleOwners() {
            this.owner = null;
            this.shared = true;
        }
    }

    private static class LocalJoin {
        private final Var var;
        private final NaryJoin join;

        public LocalJoin(Var key2, NaryJoin value) {
            this.var = key2;
            this.join = value;
        }

        public Var getVar() {
            return this.var;
        }

        public NaryJoin getJoin() {
            return this.join;
        }

        public String toString() {
            return this.var + "=" + this.join;
        }
    }

    private static class Owned<O> {
        private final RepositoryConnection owner;
        private O operation;

        public Owned(RepositoryConnection owner, O operation) {
            this.owner = owner;
            this.operation = operation;
        }

        public RepositoryConnection getOwner() {
            return this.owner;
        }

        public O getOperation() {
            return this.operation;
        }

        public void setOperation(O operation) {
            this.operation = operation;
        }

        public String toString() {
            return this.owner + "=" + this.operation;
        }
    }
}

