/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.runtime;

import java.net.MalformedURLException;
import java.util.Collection;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.RDFS;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositoryConfig;
import org.eclipse.rdf4j.repository.http.config.HTTPRepositorySchema;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.eclipse.rdf4j.repository.sail.config.ProxyRepositorySchema;
import org.eclipse.rdf4j.repository.sail.config.SailRepositorySchema;
import org.eclipse.rdf4j.repository.sparql.config.SPARQLRepositoryConfig;
import org.eclipse.rdf4j.sail.config.SailConfigSchema;
import org.eclipse.rdf4j.sail.federation.config.FederationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryManagerFederator {
    private static final Logger LOGGER = LoggerFactory.getLogger(RepositoryManagerFederator.class);
    private final RepositoryManager manager;
    private final ValueFactory valueFactory;

    public RepositoryManagerFederator(RepositoryManager manager) {
        this.manager = manager;
        this.valueFactory = manager.getSystemRepository().getValueFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFed(String fedID, String description, Collection<String> members, boolean readonly, boolean distinct2) throws MalformedURLException, RDF4JException {
        if (members.contains(fedID)) {
            throw new RepositoryConfigException("A federation member may not have the same ID as the federation.");
        }
        LinkedHashModel graph = new LinkedHashModel();
        BNode fedRepoNode = this.valueFactory.createBNode();
        LOGGER.debug("Federation repository root node: {}", (Object)fedRepoNode);
        RepositoryManagerFederator.addToGraph(graph, fedRepoNode, RDF.TYPE, RepositoryConfigSchema.REPOSITORY);
        RepositoryManagerFederator.addToGraph(graph, fedRepoNode, RepositoryConfigSchema.REPOSITORYID, this.valueFactory.createLiteral(fedID));
        RepositoryManagerFederator.addToGraph(graph, fedRepoNode, RDFS.LABEL, this.valueFactory.createLiteral(description));
        try (RepositoryConnection con = this.manager.getSystemRepository().getConnection();){
            this.addImplementation(members, graph, fedRepoNode, con, readonly, distinct2);
        }
        RepositoryConfig fedConfig = RepositoryConfig.create(graph, fedRepoNode);
        fedConfig.validate();
        this.manager.addRepositoryConfig(fedConfig);
    }

    private void addImplementation(Collection<String> members, Model graph, BNode fedRepoNode, RepositoryConnection con, boolean readonly, boolean distinct2) throws RDF4JException, MalformedURLException {
        BNode implRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, fedRepoNode, RepositoryConfigSchema.REPOSITORYIMPL, implRoot);
        RepositoryManagerFederator.addToGraph(graph, implRoot, RepositoryConfigSchema.REPOSITORYTYPE, this.valueFactory.createLiteral("openrdf:SailRepository"));
        this.addSail(members, graph, implRoot, con, readonly, distinct2);
    }

    private void addSail(Collection<String> members, Model graph, BNode implRoot, RepositoryConnection con, boolean readonly, boolean distinct2) throws RDF4JException, MalformedURLException {
        BNode sailRoot = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, implRoot, SailRepositorySchema.SAILIMPL, sailRoot);
        RepositoryManagerFederator.addToGraph(graph, sailRoot, SailConfigSchema.SAILTYPE, this.valueFactory.createLiteral("openrdf:Federation"));
        RepositoryManagerFederator.addToGraph(graph, sailRoot, FederationConfig.READ_ONLY, this.valueFactory.createLiteral(readonly));
        RepositoryManagerFederator.addToGraph(graph, sailRoot, FederationConfig.DISTINCT, this.valueFactory.createLiteral(distinct2));
        for (String member : members) {
            this.addMember(graph, sailRoot, member, con);
        }
    }

    private void addMember(Model graph, BNode sailRoot, String identifier, RepositoryConnection con) throws RDF4JException, MalformedURLException {
        LOGGER.debug("Adding member: {}", (Object)identifier);
        BNode memberNode = this.valueFactory.createBNode();
        RepositoryManagerFederator.addToGraph(graph, sailRoot, FederationConfig.MEMBER, memberNode);
        String memberRepoType = this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig().getType();
        if (!"openrdf:SPARQLRepository".equals(memberRepoType) && !"openrdf:HTTPRepository".equals(memberRepoType)) {
            memberRepoType = "openrdf:ProxyRepository";
        }
        RepositoryManagerFederator.addToGraph(graph, memberNode, RepositoryConfigSchema.REPOSITORYTYPE, this.valueFactory.createLiteral(memberRepoType));
        RepositoryManagerFederator.addToGraph(graph, memberNode, this.getLocationPredicate(memberRepoType), this.getMemberLocator(identifier, con, memberRepoType));
        LOGGER.debug("Added member {}: ", (Object)identifier);
    }

    private IRI getLocationPredicate(String memberRepoType) {
        IRI predicate = "openrdf:SPARQLRepository".equals(memberRepoType) ? SPARQLRepositoryConfig.QUERY_ENDPOINT : ("openrdf:HTTPRepository".equals(memberRepoType) ? HTTPRepositorySchema.REPOSITORYURL : ProxyRepositorySchema.PROXIED_ID);
        return predicate;
    }

    private Value getMemberLocator(String identifier, RepositoryConnection con, String memberRepoType) throws MalformedURLException, RepositoryConfigException, RDF4JException {
        Value locator = "openrdf:HTTPRepository".equals(memberRepoType) ? this.valueFactory.createIRI(((HTTPRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getURL()) : ("openrdf:SPARQLRepository".equals(memberRepoType) ? this.valueFactory.createIRI(((SPARQLRepositoryConfig)this.manager.getRepositoryConfig(identifier).getRepositoryImplConfig()).getQueryEndpointUrl()) : this.valueFactory.createLiteral(identifier));
        return locator;
    }

    private static void addToGraph(Model graph, Resource subject, IRI predicate, Value object) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(subject + " " + predicate + " " + object);
        }
        graph.add(subject, predicate, object, new Resource[0]);
    }
}

