/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.datatypes;

import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.util.LiteralUtilException;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.rio.DatatypeHandler;

public class RDFDatatypeHandler
implements DatatypeHandler {
    @Override
    public boolean isRecognizedDatatype(IRI datatypeUri) {
        if (datatypeUri == null) {
            throw new NullPointerException("Datatype URI cannot be null");
        }
        return RDF.LANGSTRING.equals(datatypeUri) || RDF.XMLLITERAL.equals(datatypeUri) || RDF.HTML.equals(datatypeUri);
    }

    @Override
    public boolean verifyDatatype(String literalValue, IRI datatypeUri) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            return true;
        }
        throw new LiteralUtilException("Could not verify RDF builtin literal");
    }

    @Override
    public Literal normalizeDatatype(String literalValue, IRI datatypeUri, ValueFactory valueFactory) throws LiteralUtilException {
        if (this.isRecognizedDatatype(datatypeUri)) {
            if (literalValue == null) {
                throw new NullPointerException("Literal value cannot be null");
            }
            try {
                return valueFactory.createLiteral(literalValue, datatypeUri);
            }
            catch (IllegalArgumentException e2) {
                throw new LiteralUtilException("Could not normalise RDF vocabulary defined literal", e2);
            }
        }
        throw new LiteralUtilException("Could not normalise RDF vocabulary defined literal");
    }

    @Override
    public String getKey() {
        return "org.eclipse.rdf4j.rio.datatypes.rdf";
    }
}

