/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.util;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.rdf4j.OpenRDFUtil;
import org.eclipse.rdf4j.RDF4JException;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFHandler;

public abstract class AbstractRDFInserter
extends AbstractRDFHandler {
    protected Resource[] contexts = new Resource[0];
    private boolean preserveBNodeIDs = true;
    private final Map<String, String> namespaceMap = new HashMap<String, String>();
    private final Map<String, BNode> bNodesMap = new HashMap<String, BNode>();
    private final ValueFactory valueFactory;

    protected AbstractRDFInserter(ValueFactory vf) {
        this.valueFactory = vf;
    }

    public void setPreserveBNodeIDs(boolean preserveBNodeIDs) {
        this.preserveBNodeIDs = preserveBNodeIDs;
    }

    public boolean preservesBNodeIDs() {
        return this.preserveBNodeIDs;
    }

    public void enforceContext(Resource ... contexts) {
        OpenRDFUtil.verifyContextNotNull(contexts);
        this.contexts = Arrays.copyOf(contexts, contexts.length);
    }

    public boolean enforcesContext() {
        return this.contexts.length != 0;
    }

    public Resource[] getContexts() {
        return Arrays.copyOf(this.contexts, this.contexts.length);
    }

    protected abstract void addNamespace(String var1, String var2) throws RDF4JException;

    protected abstract void addStatement(Resource var1, IRI var2, Value var3, Resource var4) throws RDF4JException;

    @Override
    public void endRDF() throws RDFHandlerException {
        for (Map.Entry<String, String> entry : this.namespaceMap.entrySet()) {
            String prefix = entry.getKey();
            String name2 = entry.getValue();
            try {
                this.addNamespace(prefix, name2);
            }
            catch (RDF4JException e2) {
                throw new RDFHandlerException(e2);
            }
        }
        this.namespaceMap.clear();
        this.bNodesMap.clear();
    }

    @Override
    public void handleNamespace(String prefix, String name2) {
        if (prefix != null && !this.namespaceMap.containsKey(prefix)) {
            this.namespaceMap.put(prefix, name2);
        }
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        Resource ctxt = st.getContext();
        if (!this.preserveBNodeIDs) {
            if (subj instanceof BNode) {
                subj = this.mapBNode((BNode)subj);
            }
            if (obj instanceof BNode) {
                obj = this.mapBNode((BNode)obj);
            }
            if (!this.enforcesContext() && ctxt instanceof BNode) {
                ctxt = this.mapBNode((BNode)ctxt);
            }
        }
        try {
            this.addStatement(subj, pred, obj, ctxt);
        }
        catch (RDF4JException e2) {
            throw new RDFHandlerException(e2);
        }
    }

    private BNode mapBNode(BNode bNode) {
        BNode result = this.bNodesMap.get(bNode.getID());
        if (result == null) {
            result = this.valueFactory.createBNode();
            this.bNodesMap.put(bNode.getID(), result);
        }
        return result;
    }
}

