/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.io.IOException;
import org.eclipse.rdf4j.http.client.SPARQLProtocolSession;
import org.eclipse.rdf4j.http.client.query.AbstractHTTPUpdate;
import org.eclipse.rdf4j.http.protocol.UnauthorizedException;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.QueryInterruptedException;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.sparql.query.QueryStringUtil;

public class SPARQLUpdate
extends AbstractHTTPUpdate {
    public SPARQLUpdate(SPARQLProtocolSession httpClient, String baseURI, String queryString) {
        super(httpClient, QueryLanguage.SPARQL, queryString, baseURI);
    }

    @Override
    public void execute() throws UpdateExecutionException {
        try {
            SPARQLProtocolSession client = this.getHttpClient();
            try {
                client.sendUpdate(this.getQueryLanguage(), this.getQueryString(), this.getBaseURI(), this.dataset, this.includeInferred, this.getMaxExecutionTime(), this.getBindingsArray());
            }
            catch (UnauthorizedException e2) {
                throw new UpdateExecutionException(e2.getMessage(), e2);
            }
            catch (QueryInterruptedException e3) {
                throw new UpdateExecutionException(e3.getMessage(), e3);
            }
            catch (MalformedQueryException e4) {
                throw new UpdateExecutionException(e4.getMessage(), e4);
            }
            catch (IOException e5) {
                throw new UpdateExecutionException(e5.getMessage(), e5);
            }
        }
        catch (RepositoryException e6) {
            throw new UpdateExecutionException(e6.getMessage(), e6);
        }
    }

    @Override
    public String getQueryString() {
        return QueryStringUtil.getQueryString(this.queryString, this.getBindings());
    }
}

