/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.sparql.query;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.regex.Pattern;
import org.apache.http.client.HttpClient;
import org.eclipse.rdf4j.common.net.ParsedURI;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.Operation;
import org.eclipse.rdf4j.query.impl.MapBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleDataset;

@Deprecated
public abstract class SPARQLOperation
implements Operation {
    private static Executor executor = Executors.newCachedThreadPool();
    protected HttpClient client;
    private String url;
    protected Dataset dataset = new SimpleDataset();
    private String operation;
    protected MapBindingSet bindings = new MapBindingSet();

    public SPARQLOperation(HttpClient client, String url, String base, String operation) {
        boolean abs;
        this.url = url;
        this.operation = operation;
        this.client = client;
        boolean bl = abs = base != null && base.length() > 0 && new ParsedURI(base).isAbsolute();
        if (abs && !operation.toUpperCase().contains("BASE")) {
            this.operation = "BASE <" + base + "> " + operation;
        }
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public BindingSet getBindings() {
        return this.bindings;
    }

    @Override
    public Dataset getDataset() {
        return this.dataset;
    }

    @Override
    public boolean getIncludeInferred() {
        return true;
    }

    @Override
    public void removeBinding(String name2) {
        this.bindings.removeBinding(name2);
    }

    @Override
    public void setBinding(String name2, Value value) {
        assert (value instanceof Literal || value instanceof IRI);
        this.bindings.addBinding(name2, value);
    }

    @Override
    public void clearBindings() {
        this.bindings.clear();
    }

    @Override
    public void setDataset(Dataset dataset) {
        this.dataset = dataset;
    }

    @Override
    public void setIncludeInferred(boolean inf) {
        if (!inf) {
            throw new UnsupportedOperationException();
        }
    }

    protected void execute(Runnable command) {
        executor.execute(command);
    }

    protected Set<String> getBindingNames() {
        if (this.bindings.size() == 0) {
            return Collections.EMPTY_SET;
        }
        HashSet<String> names = new HashSet<String>();
        String qry = this.operation;
        int b = qry.indexOf(123);
        String select2 = qry.substring(0, b);
        for (String name2 : this.bindings.getBindingNames()) {
            String pattern;
            String replacement = this.getReplacement(this.bindings.getValue(name2));
            if (replacement == null || !Pattern.compile(pattern = ".*[\\?\\$]" + name2 + "\\W.*", 40).matcher(select2).matches()) continue;
            names.add(name2);
        }
        return names;
    }

    protected String getQueryString() {
        if (this.bindings.size() == 0) {
            return this.operation;
        }
        String qry = this.operation;
        int b = qry.indexOf(123);
        String select2 = qry.substring(0, b);
        String where = qry.substring(b);
        for (String name2 : this.bindings.getBindingNames()) {
            String replacement = this.getReplacement(this.bindings.getValue(name2));
            if (replacement == null) continue;
            String pattern = "[\\?\\$]" + name2 + "(?=\\W)";
            select2 = select2.replaceAll(pattern, "");
            where = where.replaceAll(pattern, replacement);
        }
        return select2 + where;
    }

    private String getReplacement(Value value) {
        StringBuilder sb = new StringBuilder();
        if (value instanceof IRI) {
            return this.appendValue(sb, (IRI)value).toString();
        }
        if (value instanceof Literal) {
            return this.appendValue(sb, (Literal)value).toString();
        }
        throw new IllegalArgumentException("BNode references not supported by SPARQL end-points");
    }

    private StringBuilder appendValue(StringBuilder sb, IRI uri) {
        sb.append("<").append(uri.stringValue()).append(">");
        return sb;
    }

    private StringBuilder appendValue(StringBuilder sb, Literal lit) {
        sb.append('\"');
        sb.append(lit.getLabel().replace("\"", "\\\""));
        sb.append('\"');
        if (Literals.isLanguageLiteral(lit)) {
            sb.append('@');
            sb.append(lit.getLanguage().get());
        } else {
            sb.append("^^<");
            sb.append(lit.getDatatype().stringValue());
            sb.append('>');
        }
        return sb;
    }
}

