/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.manager;

import java.io.File;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigUtil;
import org.eclipse.rdf4j.repository.event.NotifyingRepositoryConnection;
import org.eclipse.rdf4j.repository.event.base.NotifyingRepositoryWrapper;
import org.eclipse.rdf4j.repository.manager.SystemRepositoryConfig;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemRepository
extends NotifyingRepositoryWrapper {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String ID = "SYSTEM";
    public static final String TITLE = "System configuration repository";
    public static final String REPOSITORY_TYPE = "openrdf:SystemRepository";

    public SystemRepository(File systemDir) throws RepositoryException {
        super.setDelegate(new SailRepository(new MemoryStore(systemDir)));
    }

    @Override
    public void initialize() throws RepositoryException {
        super.initialize();
        try (NotifyingRepositoryConnection con = this.getConnection();){
            if (con.isEmpty()) {
                this.logger.debug("Initializing empty {} repository", (Object)ID);
                con.begin();
                con.setNamespace("rdf", "http://www.w3.org/1999/02/22-rdf-syntax-ns#");
                con.setNamespace("sys", "http://www.openrdf.org/config/repository#");
                con.commit();
                RepositoryConfig repConfig = new RepositoryConfig(ID, TITLE, new SystemRepositoryConfig());
                RepositoryConfigUtil.updateRepositoryConfigs(con, repConfig);
            }
        }
    }

    @Override
    public void setDelegate(Repository delegate) {
        throw new UnsupportedOperationException("Setting delegate on system repository not allowed");
    }
}

