/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.repository.base;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.eclipse.rdf4j.IsolationLevel;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Namespace;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BooleanQuery;
import org.eclipse.rdf4j.query.GraphQuery;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.Query;
import org.eclipse.rdf4j.query.QueryLanguage;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.Update;
import org.eclipse.rdf4j.repository.DelegatingRepositoryConnection;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.eclipse.rdf4j.repository.RepositoryResult;
import org.eclipse.rdf4j.repository.UnknownTransactionStateException;
import org.eclipse.rdf4j.repository.base.AbstractRepositoryConnection;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;

public class RepositoryConnectionWrapper
extends AbstractRepositoryConnection
implements DelegatingRepositoryConnection {
    private volatile RepositoryConnection delegate;

    public RepositoryConnectionWrapper(Repository repository2) {
        super(repository2);
    }

    public RepositoryConnectionWrapper(Repository repository2, RepositoryConnection delegate) {
        this(repository2);
        this.setDelegate(delegate);
    }

    @Override
    public RepositoryConnection getDelegate() {
        return this.delegate;
    }

    @Override
    public void setDelegate(RepositoryConnection delegate) {
        this.delegate = delegate;
        this.setParserConfig(delegate.getParserConfig());
    }

    protected boolean isDelegatingAdd() throws RepositoryException {
        return true;
    }

    protected boolean isDelegatingRead() throws RepositoryException {
        return true;
    }

    protected boolean isDelegatingRemove() throws RepositoryException {
        return true;
    }

    @Override
    public void setParserConfig(ParserConfig parserConfig) {
        super.setParserConfig(parserConfig);
        if (this.getDelegate() != null) {
            this.getDelegate().setParserConfig(parserConfig);
        }
    }

    @Override
    public void add(File file2, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(file2, baseURI, dataFormat, contexts);
        } else {
            super.add(file2, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(in, baseURI, dataFormat, contexts);
        } else {
            super.add(in, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(statements, contexts);
        } else {
            super.add(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(statementIter, contexts);
        } else {
            super.add(statementIter, contexts);
        }
    }

    @Override
    public void add(Reader reader2, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(reader2, baseURI, dataFormat, contexts);
        } else {
            super.add(reader2, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(subject, predicate, object, contexts);
        } else {
            super.add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(st, contexts);
        } else {
            super.add(st, contexts);
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(url, baseURI, dataFormat, contexts);
        } else {
            super.add(url, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().clear(contexts);
        } else {
            super.clear(contexts);
        }
    }

    @Override
    public void close() throws RepositoryException {
        try {
            super.close();
        }
        finally {
            this.getDelegate().close();
        }
    }

    @Override
    public void commit() throws RepositoryException {
        this.getDelegate().commit();
    }

    @Override
    public void exportStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (this.isDelegatingRead()) {
            this.getDelegate().exportStatements(subj, pred, obj, includeInferred, handler, contexts);
        } else {
            this.exportStatements(this.getStatements(subj, pred, obj, includeInferred, contexts), handler);
        }
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        return this.getDelegate().getContextIDs();
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        return this.getDelegate().getNamespace(prefix);
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return this.getDelegate().getNamespaces();
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.getDelegate().getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Resource subj, IRI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().hasStatement(subj, pred, obj, includeInferred, contexts);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().hasStatement(st, includeInferred, contexts);
        }
        return super.hasStatement(st, includeInferred, contexts);
    }

    @Override
    @Deprecated
    public boolean isAutoCommit() throws RepositoryException {
        return this.getDelegate().isAutoCommit();
    }

    @Override
    public boolean isActive() throws UnknownTransactionStateException, RepositoryException {
        return this.getDelegate().isActive();
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().isEmpty();
        }
        return super.isEmpty();
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.getDelegate().isOpen();
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareGraphQuery(ql, query, baseURI);
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareQuery(ql, query, baseURI);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareTupleQuery(ql, query, baseURI);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareBooleanQuery(ql, query, baseURI);
    }

    @Override
    public Update prepareUpdate(QueryLanguage ql, String update2, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareUpdate(ql, update2, baseURI);
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(statements, contexts);
        } else {
            super.remove(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(statementIter, contexts);
        } else {
            super.remove(statementIter, contexts);
        }
    }

    @Override
    public void remove(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(subject, predicate, object, contexts);
        } else {
            super.remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(st, contexts);
        } else {
            super.remove(st, contexts);
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        this.getDelegate().removeNamespace(prefix);
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        this.getDelegate().clearNamespaces();
    }

    @Override
    public void rollback() throws RepositoryException {
        this.getDelegate().rollback();
    }

    @Override
    @Deprecated
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        super.setAutoCommit(autoCommit);
        this.getDelegate().setAutoCommit(autoCommit);
    }

    @Override
    public void setNamespace(String prefix, String name2) throws RepositoryException {
        this.getDelegate().setNamespace(prefix, name2);
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        return this.getDelegate().size(contexts);
    }

    @Override
    protected void addWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.getDelegate().add(subject, predicate, object, contexts);
    }

    @Override
    protected void removeWithoutCommit(Resource subject, IRI predicate, Value object, Resource ... contexts) throws RepositoryException {
        this.getDelegate().remove(subject, predicate, object, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportStatements(RepositoryResult<Statement> stIter, RDFHandler handler) throws RepositoryException, RDFHandlerException {
        try {
            handler.startRDF();
            try (RepositoryResult<Namespace> nsIter = this.getNamespaces();){
                while (nsIter.hasNext()) {
                    Namespace ns2 = nsIter.next();
                    handler.handleNamespace(ns2.getPrefix(), ns2.getName());
                }
            }
            while (stIter.hasNext()) {
                handler.handleStatement(stIter.next());
            }
            handler.endRDF();
        }
        finally {
            stIter.close();
        }
    }

    @Override
    public void begin() throws RepositoryException {
        this.getDelegate().begin();
    }

    @Override
    public void begin(IsolationLevel level) throws RepositoryException {
        this.getDelegate().begin(level);
    }

    @Override
    public void setIsolationLevel(IsolationLevel level) throws IllegalStateException {
        this.getDelegate().setIsolationLevel(level);
    }

    @Override
    public IsolationLevel getIsolationLevel() {
        return this.getDelegate().getIsolationLevel();
    }
}

