/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDescribe;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDescribeQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperation;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTProjectionElem;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSelect;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTSelectQuery;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTWhereClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.Node;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class WildcardProjectionProcessor
extends AbstractASTVisitor {
    public static void process(ASTOperationContainer container) throws MalformedQueryException {
        ASTDescribeQuery describeQuery;
        ASTDescribe describeClause;
        ASTWhereClause whereClause;
        ASTOperation operation = container.getOperation();
        if (operation != null && (whereClause = operation.getWhereClause()) != null) {
            SelectClauseCollector collector = new SelectClauseCollector();
            try {
                whereClause.jjtAccept(collector, null);
                Set<ASTSelect> selectClauses = collector.getSelectClauses();
                for (ASTSelect selectClause : selectClauses) {
                    if (!selectClause.isWildcard()) continue;
                    ASTSelectQuery q = (ASTSelectQuery)selectClause.jjtGetParent();
                    WildcardProjectionProcessor.addQueryVars(q.getWhereClause(), selectClause);
                    selectClause.setWildcard(false);
                }
            }
            catch (VisitorException e2) {
                throw new MalformedQueryException(e2);
            }
        }
        if (operation instanceof ASTSelectQuery) {
            ASTSelectQuery selectQuery = (ASTSelectQuery)operation;
            ASTSelect selectClause = selectQuery.getSelect();
            if (selectClause.isWildcard()) {
                WildcardProjectionProcessor.addQueryVars(selectQuery.getWhereClause(), selectClause);
                selectClause.setWildcard(false);
            }
        } else if (operation instanceof ASTDescribeQuery && (describeClause = (describeQuery = (ASTDescribeQuery)operation).getDescribe()).isWildcard()) {
            WildcardProjectionProcessor.addQueryVars(describeQuery.getWhereClause(), describeClause);
            describeClause.setWildcard(false);
        }
    }

    private static void addQueryVars(ASTWhereClause queryBody, Node wildcardNode) throws MalformedQueryException {
        QueryVariableCollector visitor = new QueryVariableCollector();
        try {
            queryBody.jjtAccept(visitor, null);
            for (String varName : visitor.getVariableNames()) {
                ASTVar varNode = new ASTVar(49);
                ASTProjectionElem projectionElemNode = new ASTProjectionElem(8);
                varNode.setName(varName);
                projectionElemNode.jjtAppendChild(varNode);
                varNode.jjtSetParent(projectionElemNode);
                wildcardNode.jjtAppendChild(projectionElemNode);
                projectionElemNode.jjtSetParent(wildcardNode);
            }
        }
        catch (VisitorException e2) {
            throw new MalformedQueryException(e2);
        }
    }

    private static class SelectClauseCollector
    extends AbstractASTVisitor {
        private Set<ASTSelect> selectClauses = new LinkedHashSet<ASTSelect>();

        private SelectClauseCollector() {
        }

        public Set<ASTSelect> getSelectClauses() {
            return this.selectClauses;
        }

        @Override
        public Object visit(ASTSelect node2, Object data2) throws VisitorException {
            this.selectClauses.add(node2);
            return super.visit(node2, data2);
        }
    }

    private static class QueryVariableCollector
    extends AbstractASTVisitor {
        private Set<String> variableNames = new LinkedHashSet<String>();

        private QueryVariableCollector() {
        }

        public Set<String> getVariableNames() {
            return this.variableNames;
        }

        @Override
        public Object visit(ASTSelectQuery node2, Object data2) throws VisitorException {
            return this.visit(node2.getSelect(), data2);
        }

        @Override
        public Object visit(ASTProjectionElem node2, Object data2) throws VisitorException {
            String alias2 = node2.getAlias();
            if (alias2 != null) {
                this.variableNames.add(alias2);
                return null;
            }
            return super.visit(node2, data2);
        }

        @Override
        public Object visit(ASTVar node2, Object data2) throws VisitorException {
            if (!node2.isAnonymous()) {
                this.variableNames.add(node2.getName());
            }
            return super.visit(node2, data2);
        }
    }
}

