/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.Add;
import org.eclipse.rdf4j.query.algebra.Clear;
import org.eclipse.rdf4j.query.algebra.Copy;
import org.eclipse.rdf4j.query.algebra.Create;
import org.eclipse.rdf4j.query.algebra.DeleteData;
import org.eclipse.rdf4j.query.algebra.InsertData;
import org.eclipse.rdf4j.query.algebra.Load;
import org.eclipse.rdf4j.query.algebra.Modify;
import org.eclipse.rdf4j.query.algebra.Move;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UpdateExpr;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.parser.sparql.GraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.TupleExprBuilder;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTAdd;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTClear;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCopy;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTCreate;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteWhere;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDrop;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGraphOrDefault;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTGraphRefAll;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInsertClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInsertData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTLoad;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTModify;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTMove;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTQuadsNotTriples;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUpdate;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTWhereClause;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class UpdateExprBuilder
extends TupleExprBuilder {
    public UpdateExprBuilder(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public UpdateExpr visit(ASTUpdate node2, Object data2) throws VisitorException {
        if (node2 instanceof ASTModify) {
            return this.visit((ASTModify)node2, data2);
        }
        if (node2 instanceof ASTInsertData) {
            return this.visit((ASTInsertData)node2, data2);
        }
        return null;
    }

    @Override
    public InsertData visit(ASTInsertData node2, Object data2) throws VisitorException {
        ASTUnparsedQuadDataBlock dataBlock = node2.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        InsertData insertData = new InsertData(dataBlock.getDataBlock());
        insertData.setLineNumberOffset(dataBlock.getAddedDefaultPrefixes());
        return insertData;
    }

    @Override
    public DeleteData visit(ASTDeleteData node2, Object data2) throws VisitorException {
        ASTUnparsedQuadDataBlock dataBlock = node2.jjtGetChild(ASTUnparsedQuadDataBlock.class);
        DeleteData deleteData = new DeleteData(dataBlock.getDataBlock());
        deleteData.setLineNumberOffset(dataBlock.getAddedDefaultPrefixes());
        return deleteData;
    }

    @Override
    public TupleExpr visit(ASTQuadsNotTriples node2, Object data2) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        ValueExpr contextNode = (ValueExpr)node2.jjtGetChild(0).jjtAccept(this, data2);
        Var contextVar = this.mapValueExprToVar(contextNode);
        this.graphPattern.setContextVar(contextVar);
        this.graphPattern.setStatementPatternScope(StatementPattern.Scope.NAMED_CONTEXTS);
        for (int i = 1; i < node2.jjtGetNumChildren(); ++i) {
            node2.jjtGetChild(i).jjtAccept(this, data2);
        }
        TupleExpr result = this.graphPattern.buildTupleExpr();
        parentGP.addRequiredTE(result);
        this.graphPattern = parentGP;
        return result;
    }

    @Override
    public Modify visit(ASTDeleteWhere node2, Object data2) throws VisitorException {
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            node2.jjtGetChild(i).jjtAccept(this, data2);
        }
        TupleExpr whereExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        TupleExpr deleteExpr = whereExpr.clone();
        TupleExprBuilder.VarCollector collector = new TupleExprBuilder.VarCollector();
        deleteExpr.visit(collector);
        for (Var var : collector.getCollectedVars()) {
            if (!var.isAnonymous() || var.hasValue()) continue;
            throw new VisitorException("DELETE WHERE may not contain blank nodes");
        }
        Modify modify = new Modify(deleteExpr, null, whereExpr);
        return modify;
    }

    @Override
    public Load visit(ASTLoad node2, Object data2) throws VisitorException {
        ValueConstant source2 = (ValueConstant)node2.jjtGetChild(0).jjtAccept(this, data2);
        Load load2 = new Load(source2);
        load2.setSilent(node2.isSilent());
        if (node2.jjtGetNumChildren() > 1) {
            ValueConstant graph = (ValueConstant)node2.jjtGetChild(1).jjtAccept(this, data2);
            load2.setGraph(graph);
        }
        return load2;
    }

    @Override
    public Clear visit(ASTClear node2, Object data2) throws VisitorException {
        Clear clear = new Clear();
        clear.setSilent(node2.isSilent());
        ASTGraphRefAll graphRef = node2.jjtGetChild(ASTGraphRefAll.class);
        if (graphRef.jjtGetNumChildren() > 0) {
            ValueConstant graph = (ValueConstant)graphRef.jjtGetChild(0).jjtAccept(this, data2);
            clear.setGraph(graph);
        } else if (graphRef.isDefault()) {
            clear.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        } else if (graphRef.isNamed()) {
            clear.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        return clear;
    }

    @Override
    public Clear visit(ASTDrop node2, Object data2) throws VisitorException {
        Clear clear = new Clear();
        clear.setSilent(node2.isSilent());
        ASTGraphRefAll graphRef = node2.jjtGetChild(ASTGraphRefAll.class);
        if (graphRef.jjtGetNumChildren() > 0) {
            ValueConstant graph = (ValueConstant)graphRef.jjtGetChild(0).jjtAccept(this, data2);
            clear.setGraph(graph);
        } else if (graphRef.isDefault()) {
            clear.setScope(StatementPattern.Scope.DEFAULT_CONTEXTS);
        } else if (graphRef.isNamed()) {
            clear.setScope(StatementPattern.Scope.NAMED_CONTEXTS);
        }
        return clear;
    }

    @Override
    public Create visit(ASTCreate node2, Object data2) throws VisitorException {
        ValueConstant graph = (ValueConstant)node2.jjtGetChild(0).jjtAccept(this, data2);
        Create create = new Create(graph);
        create.setSilent(node2.isSilent());
        return create;
    }

    @Override
    public Copy visit(ASTCopy node2, Object data2) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Copy copy2 = new Copy();
        copy2.setSilent(node2.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node2.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data2);
            copy2.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node2.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data2);
            copy2.setDestinationGraph(destinationGraph);
        }
        return copy2;
    }

    @Override
    public Move visit(ASTMove node2, Object data2) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Move move = new Move();
        move.setSilent(node2.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node2.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data2);
            move.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node2.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data2);
            move.setDestinationGraph(destinationGraph);
        }
        return move;
    }

    @Override
    public Add visit(ASTAdd node2, Object data2) throws VisitorException {
        ASTGraphOrDefault destinationNode;
        Add add = new Add();
        add.setSilent(node2.isSilent());
        ASTGraphOrDefault sourceNode = (ASTGraphOrDefault)node2.jjtGetChild(0);
        if (sourceNode.jjtGetNumChildren() > 0) {
            ValueConstant sourceGraph = (ValueConstant)sourceNode.jjtGetChild(0).jjtAccept(this, data2);
            add.setSourceGraph(sourceGraph);
        }
        if ((destinationNode = (ASTGraphOrDefault)node2.jjtGetChild(1)).jjtGetNumChildren() > 0) {
            ValueConstant destinationGraph = (ValueConstant)destinationNode.jjtGetChild(0).jjtAccept(this, data2);
            add.setDestinationGraph(destinationGraph);
        }
        return add;
    }

    @Override
    public Modify visit(ASTModify node2, Object data2) throws VisitorException {
        ASTWhereClause whereClause = node2.getWhereClause();
        TupleExpr where = null;
        if (whereClause != null) {
            where = (TupleExpr)whereClause.jjtAccept(this, data2);
        }
        TupleExpr delete2 = null;
        ASTDeleteClause deleteNode = node2.getDeleteClause();
        if (deleteNode != null) {
            delete2 = (TupleExpr)deleteNode.jjtAccept(this, data2);
        }
        TupleExpr insert = null;
        ASTInsertClause insertNode = node2.getInsertClause();
        if (insertNode != null) {
            insert = (TupleExpr)insertNode.jjtAccept(this, data2);
        }
        Modify modifyExpr = new Modify(delete2, insert, where);
        return modifyExpr;
    }

    @Override
    public TupleExpr visit(ASTDeleteClause node2, Object data2) throws VisitorException {
        TupleExpr result = (TupleExpr)data2;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            node2.jjtGetChild(i).jjtAccept(this, data2);
        }
        TupleExpr deleteExpr = this.graphPattern.buildTupleExpr();
        TupleExprBuilder.VarCollector collector = new TupleExprBuilder.VarCollector();
        deleteExpr.visit(collector);
        for (Var var : collector.getCollectedVars()) {
            if (!var.isAnonymous() || var.hasValue()) continue;
            throw new VisitorException("DELETE clause may not contain blank nodes");
        }
        this.graphPattern = parentGP;
        return deleteExpr;
    }

    @Override
    public TupleExpr visit(ASTInsertClause node2, Object data2) throws VisitorException {
        TupleExpr result = (TupleExpr)data2;
        GraphPattern parentGP = this.graphPattern;
        this.graphPattern = new GraphPattern();
        this.graphPattern.setStatementPatternScope(parentGP.getStatementPatternScope());
        this.graphPattern.setContextVar(parentGP.getContextVar());
        for (int i = 0; i < node2.jjtGetNumChildren(); ++i) {
            node2.jjtGetChild(i).jjtAccept(this, data2);
        }
        TupleExpr insertExpr = this.graphPattern.buildTupleExpr();
        this.graphPattern = parentGP;
        return insertExpr;
    }

    private Set<Var> getProjectionVars(Collection<StatementPattern> statementPatterns) {
        LinkedHashSet<Var> vars = new LinkedHashSet<Var>(statementPatterns.size() * 2);
        for (StatementPattern sp : statementPatterns) {
            vars.add(sp.getSubjectVar());
            vars.add(sp.getPredicateVar());
            vars.add(sp.getObjectVar());
            if (sp.getContextVar() == null) continue;
            vars.add(sp.getContextVar());
        }
        return vars;
    }
}

