/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.sparql;

import org.eclipse.rdf4j.common.net.ParsedURI;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.sparql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTBaseDecl;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTDeleteData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRI;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTIRIFunc;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTInsertData;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTOperationContainer;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTServiceGraphPattern;
import org.eclipse.rdf4j.query.parser.sparql.ast.ASTUnparsedQuadDataBlock;
import org.eclipse.rdf4j.query.parser.sparql.ast.VisitorException;

public class BaseDeclProcessor {
    public static void process(ASTOperationContainer qc, String externalBaseURI) throws MalformedQueryException {
        ParsedURI parsedBaseURI = null;
        ASTBaseDecl baseDecl = qc.getBaseDecl();
        if (baseDecl != null) {
            parsedBaseURI = new ParsedURI(baseDecl.getIRI());
            if (!parsedBaseURI.isAbsolute()) {
                throw new MalformedQueryException("BASE IRI is not an absolute IRI: " + externalBaseURI);
            }
        } else if (externalBaseURI != null && !(parsedBaseURI = new ParsedURI(externalBaseURI)).isAbsolute()) {
            throw new IllegalArgumentException("Supplied base URI is not an absolute IRI: " + externalBaseURI);
        }
        if (parsedBaseURI != null) {
            ASTUnparsedQuadDataBlock dataBlock = null;
            if (qc.getOperation() instanceof ASTInsertData) {
                ASTInsertData insertData = (ASTInsertData)qc.getOperation();
                dataBlock = insertData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            } else if (qc.getOperation() instanceof ASTDeleteData) {
                ASTDeleteData deleteData = (ASTDeleteData)qc.getOperation();
                dataBlock = deleteData.jjtGetChild(ASTUnparsedQuadDataBlock.class);
            }
            if (dataBlock != null) {
                String baseURIDeclaration = "BASE <" + parsedBaseURI + "> \n";
                dataBlock.setDataBlock(baseURIDeclaration + dataBlock.getDataBlock());
            } else {
                RelativeIRIResolver visitor = new RelativeIRIResolver(parsedBaseURI);
                try {
                    qc.jjtAccept(visitor, null);
                }
                catch (VisitorException e2) {
                    throw new MalformedQueryException(e2);
                }
            }
        }
    }

    private static class RelativeIRIResolver
    extends AbstractASTVisitor {
        private ParsedURI parsedBaseURI;

        public RelativeIRIResolver(ParsedURI parsedBaseURI) {
            this.parsedBaseURI = parsedBaseURI;
        }

        @Override
        public Object visit(ASTIRI node2, Object data2) throws VisitorException {
            ParsedURI resolvedURI = this.parsedBaseURI.resolve(node2.getValue());
            node2.setValue(resolvedURI.toString());
            return super.visit(node2, data2);
        }

        @Override
        public Object visit(ASTIRIFunc node2, Object data2) throws VisitorException {
            node2.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node2, data2);
        }

        @Override
        public Object visit(ASTServiceGraphPattern node2, Object data2) throws VisitorException {
            node2.setBaseURI(this.parsedBaseURI.toString());
            return super.visit(node2, data2);
        }
    }
}

