/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.parser.serql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.serql.SeRQLUtil;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLiteral;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTString;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;

class StringEscapesProcessor {
    StringEscapesProcessor() {
    }

    public static void process(ASTQueryContainer qc) throws MalformedQueryException {
        StringProcessor visitor = new StringProcessor();
        try {
            qc.jjtAccept(visitor, null);
        }
        catch (VisitorException e2) {
            throw new MalformedQueryException(e2.getMessage(), e2);
        }
    }

    private static class StringProcessor
    extends AbstractASTVisitor {
        @Override
        public Object visit(ASTString stringNode, Object data2) throws VisitorException {
            String value = stringNode.getValue();
            try {
                value = SeRQLUtil.decodeString(value);
                stringNode.setValue(value);
            }
            catch (IllegalArgumentException e2) {
                throw new VisitorException(e2.getMessage());
            }
            return super.visit(stringNode, data2);
        }

        @Override
        public Object visit(ASTLiteral literalNode, Object data2) throws VisitorException {
            String label = literalNode.getLabel();
            try {
                label = SeRQLUtil.decodeString(label);
                literalNode.setLabel(label);
            }
            catch (IllegalArgumentException e2) {
                throw new VisitorException(e2.getMessage());
            }
            return super.visit(literalNode, data2);
        }
    }
}

