/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.parser.serql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.BinaryValueOperator;
import org.eclipse.rdf4j.query.algebra.Bound;
import org.eclipse.rdf4j.query.algebra.Compare;
import org.eclipse.rdf4j.query.algebra.CompareAll;
import org.eclipse.rdf4j.query.algebra.CompareAny;
import org.eclipse.rdf4j.query.algebra.Datatype;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.Exists;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.ExtensionElem;
import org.eclipse.rdf4j.query.algebra.FunctionCall;
import org.eclipse.rdf4j.query.algebra.In;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.IsBNode;
import org.eclipse.rdf4j.query.algebra.IsLiteral;
import org.eclipse.rdf4j.query.algebra.IsResource;
import org.eclipse.rdf4j.query.algebra.IsURI;
import org.eclipse.rdf4j.query.algebra.Label;
import org.eclipse.rdf4j.query.algebra.Lang;
import org.eclipse.rdf4j.query.algebra.LangMatches;
import org.eclipse.rdf4j.query.algebra.Like;
import org.eclipse.rdf4j.query.algebra.LocalName;
import org.eclipse.rdf4j.query.algebra.Namespace;
import org.eclipse.rdf4j.query.algebra.Not;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.OrderElem;
import org.eclipse.rdf4j.query.algebra.Projection;
import org.eclipse.rdf4j.query.algebra.ProjectionElem;
import org.eclipse.rdf4j.query.algebra.ProjectionElemList;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.Regex;
import org.eclipse.rdf4j.query.algebra.SameTerm;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.Slice;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Str;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.parser.serql.AbstractASTVisitor;
import org.eclipse.rdf4j.query.parser.serql.ConstructorBuilder;
import org.eclipse.rdf4j.query.parser.serql.GraphPattern;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTAnd;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBNode;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBasicPathExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBasicPathExprTail;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBooleanConstant;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBooleanExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTBound;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTCompare;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTCompareAll;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTCompareAny;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTConstruct;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTConstructQuery;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTDatatype;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTEdge;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTExists;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTFrom;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTFunctionCall;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTGraphIntersect;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTGraphMinus;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTGraphUnion;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTIn;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTInList;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTIsBNode;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTIsLiteral;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTIsResource;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTIsURI;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLabel;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLang;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLangMatches;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLike;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLimit;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLiteral;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTLocalName;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNamespace;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNode;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNodeElem;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNot;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTNull;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOffset;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOptPathExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOptPathExprTail;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOrderBy;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTOrderExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTPathExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTPathExprTail;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTPathExprUnion;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTProjectionElem;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryBody;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTQueryContainer;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTRegex;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTReifiedStat;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTSameTerm;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTSelect;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTSelectQuery;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTStr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTString;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTTupleIntersect;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTTupleMinus;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTTupleUnion;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTURI;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTValueExpr;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTVar;
import org.eclipse.rdf4j.query.parser.serql.ast.ASTWhere;
import org.eclipse.rdf4j.query.parser.serql.ast.Node;
import org.eclipse.rdf4j.query.parser.serql.ast.VisitorException;

class QueryModelBuilder
extends AbstractASTVisitor {
    private final ValueFactory valueFactory;
    private int constantVarID = 1;
    private GraphPattern graphPattern;

    public static TupleExpr buildQueryModel(ASTQueryContainer node2, ValueFactory valueFactory) throws MalformedQueryException {
        try {
            QueryModelBuilder qmBuilder = new QueryModelBuilder(valueFactory);
            return (TupleExpr)node2.jjtAccept(qmBuilder, null);
        }
        catch (VisitorException e2) {
            throw new MalformedQueryException(e2.getMessage(), e2);
        }
    }

    public QueryModelBuilder(ValueFactory valueFactory) {
        this.valueFactory = valueFactory;
    }

    private Var createConstantVar(Value value) {
        Var var = new Var("-const-" + this.constantVarID++);
        var.setAnonymous(true);
        var.setValue(value);
        return var;
    }

    private GraphPattern parseGraphPattern(Node node2) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        try {
            node2.jjtAccept(this, null);
            GraphPattern graphPattern = this.graphPattern;
            return graphPattern;
        }
        finally {
            this.graphPattern = this.graphPattern.getParent();
        }
    }

    @Override
    public TupleExpr visit(ASTQueryContainer node2, Object data2) throws VisitorException {
        return (TupleExpr)node2.getQuery().jjtAccept(this, null);
    }

    @Override
    public TupleExpr visit(ASTTupleUnion node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        AbstractQueryModelNode result = new Union(leftArg, rightArg);
        if (node2.isDistinct()) {
            result = new Distinct((TupleExpr)((Object)result));
        }
        return result;
    }

    @Override
    public TupleExpr visit(ASTTupleMinus node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        return new Difference(leftArg, rightArg);
    }

    @Override
    public TupleExpr visit(ASTTupleIntersect node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        return new Intersection(leftArg, rightArg);
    }

    @Override
    public TupleExpr visit(ASTGraphUnion node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        AbstractQueryModelNode result = new Union(leftArg, rightArg);
        if (node2.isDistinct()) {
            result = new Distinct((TupleExpr)((Object)result));
        }
        return result;
    }

    @Override
    public TupleExpr visit(ASTGraphMinus node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        return new Difference(leftArg, rightArg);
    }

    @Override
    public TupleExpr visit(ASTGraphIntersect node2, Object data2) throws VisitorException {
        TupleExpr leftArg = (TupleExpr)node2.getLeftArg().jjtAccept(this, null);
        TupleExpr rightArg = (TupleExpr)node2.getRightArg().jjtAccept(this, null);
        return new Intersection(leftArg, rightArg);
    }

    @Override
    public TupleExpr visit(ASTSelectQuery node2, Object data2) throws VisitorException {
        ASTQueryBody queryBodyNode = node2.getQueryBody();
        TupleExpr tupleExpr = queryBodyNode != null ? (TupleExpr)queryBodyNode.jjtAccept(this, null) : new SingletonSet();
        ASTOrderBy orderByNode = node2.getOrderBy();
        if (orderByNode != null) {
            List orderElemements = (List)orderByNode.jjtAccept(this, null);
            tupleExpr = new Order(tupleExpr, orderElemements);
        }
        tupleExpr = (TupleExpr)node2.getSelectClause().jjtAccept(this, tupleExpr);
        ASTLimit limitNode = node2.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node2.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        return tupleExpr;
    }

    @Override
    public TupleExpr visit(ASTSelect node2, Object data2) throws VisitorException {
        TupleExpr result = (TupleExpr)data2;
        Extension extension = new Extension();
        ProjectionElemList projElemList = new ProjectionElemList();
        for (ASTProjectionElem projElemNode : node2.getProjectionElemList()) {
            ValueExpr valueExpr = (ValueExpr)projElemNode.getValueExpr().jjtAccept(this, null);
            String alias2 = projElemNode.getAlias();
            if (alias2 != null) {
                extension.addElement(new ExtensionElem(valueExpr, alias2));
                projElemList.addElement(new ProjectionElem(alias2));
                continue;
            }
            if (valueExpr instanceof Var) {
                Var projVar = (Var)valueExpr;
                projElemList.addElement(new ProjectionElem(projVar.getName()));
                continue;
            }
            throw new IllegalStateException("required alias for non-Var projection elements not found");
        }
        if (!extension.getElements().isEmpty()) {
            extension.setArg(result);
            result = extension;
        }
        result = new Projection(result, projElemList);
        if (node2.isDistinct()) {
            result = new Distinct(result);
        } else if (node2.isReduced()) {
            result = new Reduced(result);
        }
        return result;
    }

    @Override
    public TupleExpr visit(ASTConstructQuery node2, Object data2) throws VisitorException {
        TupleExpr tupleExpr = node2.hasQueryBody() ? (TupleExpr)node2.getQueryBody().jjtAccept(this, null) : new SingletonSet();
        ASTOrderBy orderByNode = node2.getOrderBy();
        if (orderByNode != null) {
            List orderElemements = (List)orderByNode.jjtAccept(this, null);
            tupleExpr = new Order(tupleExpr, orderElemements);
        }
        ConstructorBuilder cb = new ConstructorBuilder();
        ASTConstruct constructNode = node2.getConstructClause();
        if (!constructNode.isWildcard()) {
            TupleExpr constructExpr = (TupleExpr)constructNode.jjtAccept(this, null);
            tupleExpr = cb.buildConstructor(tupleExpr, constructExpr, constructNode.isDistinct(), constructNode.isReduced());
        } else if (node2.hasQueryBody()) {
            tupleExpr = cb.buildConstructor(tupleExpr, constructNode.isDistinct(), constructNode.isReduced());
        }
        ASTLimit limitNode = node2.getLimit();
        int limit = -1;
        if (limitNode != null) {
            limit = (Integer)limitNode.jjtAccept(this, null);
        }
        ASTOffset offsetNode = node2.getOffset();
        int offset = -1;
        if (offsetNode != null) {
            offset = (Integer)offsetNode.jjtAccept(this, null);
        }
        if (offset >= 1 || limit >= 0) {
            tupleExpr = new Slice(tupleExpr, offset, limit);
        }
        return tupleExpr;
    }

    @Override
    public TupleExpr visit(ASTConstruct node2, Object data2) throws VisitorException {
        assert (!node2.isWildcard()) : "Cannot build constructor for wildcards";
        return this.parseGraphPattern(node2.getPathExpr()).buildTupleExpr();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TupleExpr visit(ASTQueryBody node2, Object data2) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        try {
            super.visit(node2, data2);
            TupleExpr tupleExpr = this.graphPattern.buildTupleExpr();
            return tupleExpr;
        }
        finally {
            this.graphPattern = this.graphPattern.getParent();
        }
    }

    @Override
    public Object visit(ASTFrom node2, Object data2) throws VisitorException {
        StatementPattern.Scope scope = StatementPattern.Scope.DEFAULT_CONTEXTS;
        Var contextVar = null;
        if (node2.hasContextID()) {
            scope = StatementPattern.Scope.NAMED_CONTEXTS;
            ValueExpr contextID = (ValueExpr)node2.getContextID().jjtAccept(this, null);
            if (contextID instanceof Var) {
                contextVar = (Var)contextID;
            } else if (contextID instanceof ValueConstant) {
                ValueConstant vc = (ValueConstant)contextID;
                contextVar = this.createConstantVar(vc.getValue());
            } else {
                throw new IllegalArgumentException("Unexpected contextID result type: " + contextID.getClass());
            }
        }
        this.graphPattern.setStatementPatternScope(scope);
        this.graphPattern.setContextVar(contextVar);
        node2.getPathExpr().jjtAccept(this, null);
        return null;
    }

    @Override
    public Object visit(ASTWhere node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getCondition().jjtAccept(this, null);
        this.graphPattern.addConstraint(valueExpr);
        return null;
    }

    @Override
    public List<OrderElem> visit(ASTOrderBy node2, Object data2) throws VisitorException {
        List<ASTOrderExpr> orderExprList = node2.getOrderExprList();
        ArrayList<OrderElem> elements = new ArrayList<OrderElem>(orderExprList.size());
        for (ASTOrderExpr orderExpr : orderExprList) {
            elements.add((OrderElem)orderExpr.jjtAccept(this, null));
        }
        return elements;
    }

    @Override
    public OrderElem visit(ASTOrderExpr node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getValueExpr().jjtAccept(this, null);
        return new OrderElem(valueExpr, node2.isAscending());
    }

    @Override
    public Integer visit(ASTLimit node2, Object data2) throws VisitorException {
        return node2.getValue();
    }

    @Override
    public Integer visit(ASTOffset node2, Object data2) throws VisitorException {
        return node2.getValue();
    }

    @Override
    public Object visit(ASTPathExprUnion node2, Object data2) throws VisitorException {
        Iterator<ASTPathExpr> args = node2.getPathExprList().iterator();
        TupleExpr unionExpr = this.parseGraphPattern(args.next()).buildTupleExpr();
        while (args.hasNext()) {
            TupleExpr argExpr = this.parseGraphPattern(args.next()).buildTupleExpr();
            unionExpr = new Union(unionExpr, argExpr);
        }
        this.graphPattern.addRequiredTE(unionExpr);
        return null;
    }

    @Override
    public Object visit(ASTBasicPathExpr node2, Object data2) throws VisitorException {
        List subjVars = (List)node2.getHead().jjtAccept(this, null);
        node2.getTail().jjtAccept(this, subjVars);
        return null;
    }

    @Override
    public Object visit(ASTOptPathExpr node2, Object data2) throws VisitorException {
        this.graphPattern = new GraphPattern(this.graphPattern);
        super.visit(node2, data2);
        this.graphPattern.getParent().addOptionalTE(this.graphPattern);
        this.graphPattern = this.graphPattern.getParent();
        return null;
    }

    @Override
    public Object visit(ASTBasicPathExprTail tailNode, Object data2) throws VisitorException {
        List subjVars = (List)data2;
        Var predVar = (Var)tailNode.getEdge().jjtAccept(this, null);
        List objVars = (List)tailNode.getNode().jjtAccept(this, null);
        Var contextVar = this.graphPattern.getContextVar();
        StatementPattern.Scope spScope = this.graphPattern.getStatementPatternScope();
        for (Var subjVar : subjVars) {
            for (Var objVar : objVars) {
                StatementPattern sp = new StatementPattern(spScope, subjVar, predVar, objVar, contextVar);
                this.graphPattern.addRequiredTE(sp);
            }
        }
        ASTPathExprTail nextTailNode = tailNode.getNextTail();
        if (nextTailNode != null) {
            List joinVars = nextTailNode.isBranch() ? subjVars : objVars;
            nextTailNode.jjtAccept(this, joinVars);
        }
        return null;
    }

    @Override
    public Object visit(ASTOptPathExprTail tailNode, Object data2) throws VisitorException {
        List subjVars = (List)data2;
        this.graphPattern = new GraphPattern(this.graphPattern);
        tailNode.getOptionalTail().jjtAccept(this, subjVars);
        ASTWhere whereNode = tailNode.getWhereClause();
        if (whereNode != null) {
            whereNode.jjtAccept(this, null);
        }
        this.graphPattern.getParent().addOptionalTE(this.graphPattern);
        this.graphPattern = this.graphPattern.getParent();
        ASTPathExprTail nextTailNode = tailNode.getNextTail();
        if (nextTailNode != null) {
            nextTailNode.jjtAccept(this, subjVars);
        }
        return null;
    }

    @Override
    public Var visit(ASTEdge node2, Object data2) throws VisitorException {
        ValueExpr arg = (ValueExpr)node2.getValueExpr().jjtAccept(this, null);
        if (arg instanceof Var) {
            return (Var)arg;
        }
        if (arg instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)arg;
            return this.createConstantVar(vc.getValue());
        }
        throw new IllegalArgumentException("Unexpected edge argument type: " + arg.getClass());
    }

    @Override
    public List<Var> visit(ASTNode node2, Object data2) throws VisitorException {
        ArrayList<Var> nodeVars = new ArrayList<Var>();
        for (ASTNodeElem nodeElem : node2.getNodeElemList()) {
            Var nodeVar = (Var)nodeElem.jjtAccept(this, null);
            nodeVars.add(nodeVar);
        }
        for (int i = 0; i < nodeVars.size() - 1; ++i) {
            Var var1 = (Var)nodeVars.get(i);
            for (int j = i + 1; j < nodeVars.size(); ++j) {
                Var var2 = (Var)nodeVars.get(j);
                if (var1.hasValue() && var2.hasValue()) continue;
                this.graphPattern.addConstraint(new Not(new SameTerm(var1, var2)));
            }
        }
        return nodeVars;
    }

    @Override
    public Var visit(ASTNodeElem node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getChild().jjtAccept(this, null);
        if (valueExpr instanceof Var) {
            return (Var)valueExpr;
        }
        if (valueExpr instanceof ValueConstant) {
            ValueConstant vc = (ValueConstant)valueExpr;
            return this.createConstantVar(vc.getValue());
        }
        throw new IllegalArgumentException("Unexpected node element result type: " + valueExpr.getClass());
    }

    @Override
    public Var visit(ASTReifiedStat node2, Object data2) throws VisitorException {
        assert (node2.getID() != null) : "ID variable not set";
        Var subjVar = (Var)node2.getSubject().jjtAccept(this, null);
        Var predVar = (Var)node2.getPredicate().jjtAccept(this, null);
        Var objVar = (Var)node2.getObject().jjtAccept(this, null);
        Var idVar = (Var)node2.getID().jjtAccept(this, null);
        Var contextVar = this.graphPattern.getContextVar();
        StatementPattern.Scope spScope = this.graphPattern.getStatementPatternScope();
        Var rdfType = new Var("_rdfType", RDF.TYPE);
        Var rdfStatement = new Var("_rdfStatement", RDF.STATEMENT);
        Var rdfSubject = new Var("_rdfSubject", RDF.SUBJECT);
        Var rdfPredicate = new Var("_rdfPredicate", RDF.PREDICATE);
        Var rdfObject = new Var("_rdfObject", RDF.OBJECT);
        this.graphPattern.addRequiredTE(new StatementPattern(spScope, idVar, rdfType, rdfStatement, contextVar));
        this.graphPattern.addRequiredTE(new StatementPattern(spScope, idVar, rdfSubject, subjVar, contextVar));
        this.graphPattern.addRequiredTE(new StatementPattern(spScope, idVar, rdfPredicate, predVar, contextVar));
        this.graphPattern.addRequiredTE(new StatementPattern(spScope, idVar, rdfObject, objVar, contextVar));
        return idVar;
    }

    @Override
    public ValueExpr visit(ASTOr node2, Object data2) throws VisitorException {
        Iterator<ASTBooleanExpr> iter = node2.getOperandList().iterator();
        ValueExpr result = (ValueExpr)iter.next().jjtAccept(this, null);
        while (iter.hasNext()) {
            ValueExpr operand = (ValueExpr)iter.next().jjtAccept(this, null);
            result = new Or(result, operand);
        }
        return result;
    }

    @Override
    public ValueExpr visit(ASTAnd node2, Object data2) throws VisitorException {
        Iterator<ASTBooleanExpr> iter = node2.getOperandList().iterator();
        ValueExpr result = (ValueExpr)iter.next().jjtAccept(this, null);
        while (iter.hasNext()) {
            ValueExpr operand = (ValueExpr)iter.next().jjtAccept(this, null);
            result = new And(result, operand);
        }
        return result;
    }

    @Override
    public ValueConstant visit(ASTBooleanConstant node2, Object data2) throws VisitorException {
        return new ValueConstant(this.valueFactory.createLiteral(node2.getValue()));
    }

    @Override
    public Not visit(ASTNot node2, Object data2) throws VisitorException {
        return new Not((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public Bound visit(ASTBound node2, Object data2) throws VisitorException {
        return new Bound((Var)super.visit(node2, data2));
    }

    @Override
    public IsResource visit(ASTIsResource node2, Object data2) throws VisitorException {
        return new IsResource((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public IsLiteral visit(ASTIsLiteral node2, Object data2) throws VisitorException {
        return new IsLiteral((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public IsURI visit(ASTIsURI node2, Object data2) throws VisitorException {
        return new IsURI((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public IsBNode visit(ASTIsBNode node2, Object data2) throws VisitorException {
        return new IsBNode((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public LangMatches visit(ASTLangMatches node2, Object data2) throws VisitorException {
        ValueExpr tag = (ValueExpr)node2.getLanguageTag().jjtAccept(this, null);
        ValueExpr range2 = (ValueExpr)node2.getLanguageRange().jjtAccept(this, null);
        return new LangMatches(tag, range2);
    }

    @Override
    public Exists visit(ASTExists node2, Object data2) throws VisitorException {
        return new Exists((TupleExpr)super.visit(node2, data2));
    }

    @Override
    public SameTerm visit(ASTSameTerm node2, Object data2) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node2.getLeftOperand().jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node2.getRightOperand().jjtAccept(this, null);
        return new SameTerm(leftArg, rightArg);
    }

    @Override
    public Compare visit(ASTCompare node2, Object data2) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node2.getLeftOperand().jjtAccept(this, null);
        ValueExpr rightArg = (ValueExpr)node2.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp operator = node2.getOperator().getValue();
        return new Compare(leftArg, rightArg, operator);
    }

    @Override
    public CompareAny visit(ASTCompareAny node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node2.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp op = node2.getOperator().getValue();
        return new CompareAny(valueExpr, tupleExpr, op);
    }

    @Override
    public CompareAll visit(ASTCompareAll node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node2.getRightOperand().jjtAccept(this, null);
        Compare.CompareOp op = node2.getOperator().getValue();
        return new CompareAll(valueExpr, tupleExpr, op);
    }

    @Override
    public Like visit(ASTLike node2, Object data2) throws VisitorException {
        ValueExpr expr = (ValueExpr)node2.getValueExpr().jjtAccept(this, null);
        String pattern = (String)node2.getPattern().jjtAccept(this, null);
        boolean caseSensitive = !node2.ignoreCase();
        return new Like(expr, pattern, caseSensitive);
    }

    @Override
    public Regex visit(ASTRegex node2, Object data2) throws VisitorException {
        ValueExpr text = (ValueExpr)node2.getText().jjtAccept(this, null);
        ValueExpr pattern = (ValueExpr)node2.getPattern().jjtAccept(this, null);
        ValueExpr flags = null;
        if (node2.hasFlags()) {
            flags = (ValueExpr)node2.getFlags().jjtAccept(this, null);
        }
        return new Regex(text, pattern, flags);
    }

    @Override
    public In visit(ASTIn node2, Object data2) throws VisitorException {
        ValueExpr valueExpr = (ValueExpr)node2.getLeftOperand().jjtAccept(this, null);
        TupleExpr tupleExpr = (TupleExpr)node2.getRightOperand().jjtAccept(this, null);
        return new In(valueExpr, tupleExpr);
    }

    @Override
    public ValueExpr visit(ASTInList node2, Object data2) throws VisitorException {
        ValueExpr leftArg = (ValueExpr)node2.getValueExpr().jjtAccept(this, null);
        BinaryValueOperator result = null;
        for (ASTValueExpr argExpr : node2.getArgList().getElements()) {
            ValueExpr rightArg = (ValueExpr)argExpr.jjtAccept(this, null);
            if (result == null) {
                result = new SameTerm(leftArg, rightArg);
                continue;
            }
            SameTerm sameTerm = new SameTerm(leftArg.clone(), rightArg);
            result = new Or(result, sameTerm);
        }
        assert (result != null);
        return result;
    }

    @Override
    public Var visit(ASTVar node2, Object data2) throws VisitorException {
        Var var = new Var(node2.getName());
        var.setAnonymous(node2.isAnonymous());
        return var;
    }

    @Override
    public Datatype visit(ASTDatatype node2, Object data2) throws VisitorException {
        return new Datatype((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public Lang visit(ASTLang node2, Object data2) throws VisitorException {
        return new Lang((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public Label visit(ASTLabel node2, Object data2) throws VisitorException {
        return new Label((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public Namespace visit(ASTNamespace node2, Object data2) throws VisitorException {
        return new Namespace((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public LocalName visit(ASTLocalName node2, Object data2) throws VisitorException {
        return new LocalName((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public Str visit(ASTStr node2, Object data2) throws VisitorException {
        return new Str((ValueExpr)super.visit(node2, data2));
    }

    @Override
    public FunctionCall visit(ASTFunctionCall node2, Object data2) throws VisitorException {
        ValueConstant vc = (ValueConstant)node2.getURI().jjtAccept(this, null);
        assert (vc.getValue() instanceof IRI);
        FunctionCall functionCall = new FunctionCall(vc.getValue().toString(), new ValueExpr[0]);
        for (ASTValueExpr argExpr : node2.getArgList().getElements()) {
            functionCall.addArg((ValueExpr)argExpr.jjtAccept(this, null));
        }
        return functionCall;
    }

    @Override
    public Object visit(ASTNull node2, Object data2) throws VisitorException {
        throw new VisitorException("Use of NULL values in SeRQL queries has been deprecated, use BOUND(...) instead");
    }

    @Override
    public ValueConstant visit(ASTURI node2, Object data2) throws VisitorException {
        return new ValueConstant(this.valueFactory.createIRI(node2.getValue()));
    }

    @Override
    public ValueConstant visit(ASTBNode node2, Object data2) throws VisitorException {
        return new ValueConstant(this.valueFactory.createBNode(node2.getID()));
    }

    @Override
    public ValueConstant visit(ASTLiteral litNode, Object data2) throws VisitorException {
        IRI datatype = null;
        ASTValueExpr dtNode = litNode.getDatatypeNode();
        if (dtNode instanceof ASTURI) {
            datatype = this.valueFactory.createIRI(((ASTURI)dtNode).getValue());
        } else if (dtNode != null) {
            throw new IllegalArgumentException("Unexpected datatype type: " + dtNode.getClass());
        }
        Literal literal = datatype != null ? this.valueFactory.createLiteral(litNode.getLabel(), datatype) : (litNode.hasLang() ? this.valueFactory.createLiteral(litNode.getLabel(), litNode.getLang()) : this.valueFactory.createLiteral(litNode.getLabel()));
        return new ValueConstant(literal);
    }

    @Override
    public String visit(ASTString node2, Object data2) throws VisitorException {
        return node2.getValue();
    }
}

