/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.reflect.UndeclaredThrowableException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import org.eclipse.rdf4j.common.iteration.IterationWrapper;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.query.GraphQueryResult;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.impl.QueueCursor;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParser;

public class BackgroundGraphResult
extends IterationWrapper<Statement, QueryEvaluationException>
implements GraphQueryResult,
Runnable,
RDFHandler {
    private final RDFParser parser;
    private final Charset charset;
    private final InputStream in;
    private final String baseURI;
    private final CountDownLatch namespacesReady = new CountDownLatch(1);
    private final Map<String, String> namespaces = new ConcurrentHashMap<String, String>();
    private final QueueCursor<Statement> queue;

    public BackgroundGraphResult(RDFParser parser, InputStream in, Charset charset, String baseURI) {
        this(new QueueCursor<Statement>(10), parser, in, charset, baseURI);
    }

    public BackgroundGraphResult(QueueCursor<Statement> queue, RDFParser parser, InputStream in, Charset charset, String baseURI) {
        super(queue);
        this.queue = queue;
        this.parser = parser;
        this.in = in;
        this.charset = charset;
        this.baseURI = baseURI;
    }

    @Override
    public boolean hasNext() throws QueryEvaluationException {
        if (this.isClosed()) {
            return false;
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            return false;
        }
        boolean result = this.queue.hasNext();
        if (!result) {
            this.close();
        }
        return result;
    }

    @Override
    public Statement next() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new NoSuchElementException("The iteration has been closed.");
        }
        try {
            return (Statement)this.queue.next();
        }
        catch (NoSuchElementException e2) {
            this.close();
            throw e2;
        }
    }

    @Override
    public void remove() throws QueryEvaluationException {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        if (Thread.currentThread().isInterrupted()) {
            this.close();
            throw new IllegalStateException("The iteration has been closed.");
        }
        try {
            this.queue.remove();
        }
        catch (IllegalStateException e2) {
            this.close();
            throw e2;
        }
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            try {
                super.handleClose();
            }
            finally {
                try {
                    InputStream toClose = this.in;
                    if (toClose != null) {
                        toClose.close();
                    }
                }
                catch (NullPointerException toClose) {}
            }
        }
        catch (IOException e2) {
            throw new QueryEvaluationException(e2);
        }
        finally {
            this.queue.close();
        }
    }

    @Override
    public void run() {
        try {
            this.parser.setRDFHandler(this);
            if (this.charset == null) {
                this.parser.parse(this.in, this.baseURI);
            } else {
                this.parser.parse(new InputStreamReader(this.in, this.charset), this.baseURI);
            }
        }
        catch (RDFHandlerException e2) {
            this.close();
        }
        catch (Exception e3) {
            this.queue.toss(e3);
            this.close();
        }
        finally {
            this.queue.done();
            this.namespacesReady.countDown();
        }
    }

    @Override
    public void startRDF() throws RDFHandlerException {
    }

    @Override
    public Map<String, String> getNamespaces() {
        try {
            this.namespacesReady.await();
            return Collections.unmodifiableMap(this.namespaces);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            this.close();
            throw new UndeclaredThrowableException(e2);
        }
    }

    @Override
    public void handleComment(String comment2) throws RDFHandlerException {
    }

    @Override
    public void handleNamespace(String prefix, String uri) throws RDFHandlerException {
        this.namespaces.put(prefix, uri);
    }

    @Override
    public void handleStatement(Statement st) throws RDFHandlerException {
        this.namespacesReady.countDown();
        try {
            this.queue.put(st);
        }
        catch (InterruptedException e2) {
            Thread.currentThread().interrupt();
            this.close();
            throw new RDFHandlerException(e2);
        }
        if (this.isClosed()) {
            throw new RDFHandlerException("Result closed");
        }
    }

    @Override
    public void endRDF() throws RDFHandlerException {
        this.namespacesReady.countDown();
    }
}

