/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator;

import java.util.Collection;
import java.util.Comparator;
import java.util.NavigableMap;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.iterator.OrderIterator;
import org.eclipse.rdf4j.query.algebra.evaluation.limited.iterator.LimitedSizeIteratorUtil;

public class LimitedSizeOrderIteration
extends OrderIterator {
    private final AtomicLong used;
    private final long maxSize;

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator2, AtomicLong used, long maxSize) {
        this(iter, comparator2, Integer.MAX_VALUE, false, used, maxSize);
    }

    public LimitedSizeOrderIteration(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator2, long limit, boolean distinct2, AtomicLong used, long maxSize) {
        super(iter, comparator2, limit, distinct2);
        this.used = used;
        this.maxSize = maxSize;
    }

    @Override
    protected void removeLast(Collection<BindingSet> lastResults) {
        super.removeLast(lastResults);
        this.used.decrementAndGet();
    }

    @Override
    protected boolean add(BindingSet next2, Collection<BindingSet> list) throws QueryEvaluationException {
        return LimitedSizeIteratorUtil.add(next2, list, this.used, this.maxSize);
    }

    @Override
    protected Integer put(NavigableMap<BindingSet, Integer> map2, BindingSet next2, int count2) throws QueryEvaluationException {
        Integer i = (Integer)map2.get(next2);
        int oldCount = i == null ? 0 : i;
        Integer put = super.put(map2, next2, count2);
        if (oldCount < count2) {
            if (this.used.incrementAndGet() > this.maxSize) {
                throw new QueryEvaluationException("Size limited reached inside order operator query, max size is:" + this.maxSize);
            }
        } else if (oldCount > count2) {
            this.used.decrementAndGet();
        }
        return put;
    }
}

