/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.iterator;

import java.io.File;
import java.io.IOError;
import java.io.IOException;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.DelayedIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class OrderIterator
extends DelayedIteration<BindingSet, QueryEvaluationException> {
    private final CloseableIteration<BindingSet, QueryEvaluationException> iter;
    private final Comparator<BindingSet> comparator;
    private final long limit;
    private final boolean distinct;
    private final File tempFile;
    private final DB db;
    private final long iterationSyncThreshold;

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator2) {
        this(iter, comparator2, Integer.MAX_VALUE, false);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator2, long limit, boolean distinct2) {
        this(iter, comparator2, limit, distinct2, 0L);
    }

    public OrderIterator(CloseableIteration<BindingSet, QueryEvaluationException> iter, Comparator<BindingSet> comparator2, long limit, boolean distinct2, long iterationSyncThreshold) {
        this.iter = iter;
        this.comparator = comparator2;
        this.limit = limit;
        this.distinct = distinct2;
        this.iterationSyncThreshold = iterationSyncThreshold;
        if (iterationSyncThreshold > 0L) {
            try {
                this.tempFile = File.createTempFile("order-eval", null);
            }
            catch (IOException e2) {
                throw new IOError(e2);
            }
            this.db = ((DBMaker)((DBMaker)DBMaker.newFileDB(this.tempFile).deleteFilesAfterClose()).closeOnJvmShutdown()).make();
        } else {
            this.tempFile = null;
            this.db = null;
        }
    }

    protected NavigableMap<BindingSet, Integer> makeOrderedMap() {
        if (this.db == null) {
            return new TreeMap<BindingSet, Integer>(this.comparator);
        }
        return this.db.createTreeMap("iteration").comparator(this.comparator).makeOrGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Iteration<BindingSet, QueryEvaluationException> createIteration() throws QueryEvaluationException {
        final NavigableMap<BindingSet, Integer> map2 = this.makeOrderedMap();
        long size = 0L;
        try {
            while (this.iter.hasNext()) {
                BindingSet next2 = (BindingSet)this.iter.next();
                if (size >= this.limit && this.comparator.compare(next2, (BindingSet)map2.lastKey()) >= 0) continue;
                Integer count2 = (Integer)map2.get(next2);
                if (count2 == null) {
                    this.put(map2, next2, 1);
                    ++size;
                } else if (!this.distinct) {
                    count2 = count2 + 1;
                    this.put(map2, next2, count2);
                    ++size;
                }
                if (this.db != null && size % this.iterationSyncThreshold == 0L) {
                    this.db.commit();
                }
                if (size <= this.limit) continue;
                BindingSet lastKey = (BindingSet)map2.lastKey();
                Integer lastCount = (Integer)map2.get(lastKey);
                if (lastCount > 1) {
                    lastCount = lastCount - 1;
                    this.put(map2, lastKey, lastCount);
                } else {
                    this.removeLast(map2.navigableKeySet());
                }
                --size;
            }
        }
        finally {
            this.iter.close();
        }
        return new LookAheadIteration<BindingSet, QueryEvaluationException>(){
            private volatile Iterator<BindingSet> iterator;
            private volatile BindingSet currentBindingSet;
            private volatile int count;
            {
                this.iterator = map2.keySet().iterator();
                this.currentBindingSet = null;
                this.count = 0;
            }

            @Override
            protected BindingSet getNextElement() {
                if (this.count == 0 && this.iterator.hasNext()) {
                    this.currentBindingSet = this.iterator.next();
                    this.count = (Integer)map2.get(this.currentBindingSet);
                }
                if (this.count > 0) {
                    --this.count;
                    return this.currentBindingSet;
                }
                return null;
            }
        };
    }

    protected void removeLast(Collection<BindingSet> lastResults) {
        if (lastResults instanceof LinkedList) {
            ((LinkedList)lastResults).removeLast();
        } else if (lastResults instanceof List) {
            ((List)lastResults).remove(lastResults.size() - 1);
        } else {
            Iterator<BindingSet> iter = lastResults.iterator();
            while (iter.hasNext()) {
                iter.next();
            }
            iter.remove();
        }
    }

    protected boolean add(BindingSet next2, Collection<BindingSet> list) throws QueryEvaluationException {
        return list.add(next2);
    }

    protected Integer put(NavigableMap<BindingSet, Integer> map2, BindingSet set2, int count2) throws QueryEvaluationException {
        return map2.put(set2, count2);
    }

    @Override
    public void remove() throws QueryEvaluationException {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void handleClose() throws QueryEvaluationException {
        try {
            super.handleClose();
        }
        finally {
            try {
                this.iter.close();
            }
            finally {
                if (this.db != null) {
                    this.db.close();
                }
            }
        }
    }
}

