/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.And;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Or;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.SingletonSet;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.UnaryTupleOperator;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.ValueConstant;
import org.eclipse.rdf4j.query.algebra.ValueExpr;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.util.QueryEvaluationUtil;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;

public class QueryModelNormalizer
extends AbstractQueryModelVisitor<RuntimeException>
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(this);
    }

    @Override
    public void meet(Join join2) {
        super.meet(join2);
        TupleExpr leftArg = join2.getLeftArg();
        TupleExpr rightArg = join2.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            join2.replaceWith(new EmptySet());
        } else if (leftArg instanceof SingletonSet) {
            join2.replaceWith(rightArg);
        } else if (rightArg instanceof SingletonSet) {
            join2.replaceWith(leftArg);
        } else if (leftArg instanceof Union) {
            Union union2 = (Union)leftArg;
            Join leftJoin = new Join(union2.getLeftArg(), rightArg.clone());
            Join rightJoin = new Join(union2.getRightArg(), rightArg.clone());
            Union newUnion = new Union(leftJoin, rightJoin);
            join2.replaceWith(newUnion);
            newUnion.visit(this);
        } else if (rightArg instanceof Union) {
            Union union3 = (Union)rightArg;
            Join leftJoin = new Join(leftArg.clone(), union3.getLeftArg());
            Join rightJoin = new Join(leftArg.clone(), union3.getRightArg());
            Union newUnion = new Union(leftJoin, rightJoin);
            join2.replaceWith(newUnion);
            newUnion.visit(this);
        } else if (leftArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)leftArg)) {
            LeftJoin leftJoin = (LeftJoin)leftArg;
            join2.replaceWith(leftJoin);
            join2.setLeftArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg(join2);
            leftJoin.visit(this);
        } else if (rightArg instanceof LeftJoin && this.isWellDesigned((LeftJoin)rightArg)) {
            LeftJoin leftJoin = (LeftJoin)rightArg;
            join2.replaceWith(leftJoin);
            join2.setRightArg(leftJoin.getLeftArg());
            leftJoin.setLeftArg(join2);
            leftJoin.visit(this);
        }
    }

    @Override
    public void meet(LeftJoin leftJoin) {
        super.meet(leftJoin);
        TupleExpr leftArg = leftJoin.getLeftArg();
        TupleExpr rightArg = leftJoin.getRightArg();
        ValueExpr condition = leftJoin.getCondition();
        if (leftArg instanceof EmptySet) {
            leftJoin.replaceWith(leftArg);
        } else if (rightArg instanceof EmptySet) {
            leftJoin.replaceWith(leftArg);
        } else if (rightArg instanceof SingletonSet) {
            leftJoin.replaceWith(leftArg);
        } else if (condition instanceof ValueConstant) {
            boolean conditionValue;
            try {
                conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue(((ValueConstant)condition).getValue());
            }
            catch (ValueExprEvaluationException e2) {
                conditionValue = false;
            }
            if (!conditionValue) {
                leftJoin.replaceWith(leftArg);
            } else {
                leftJoin.setCondition(null);
            }
        }
    }

    @Override
    public void meet(Union union2) {
        super.meet(union2);
        TupleExpr leftArg = union2.getLeftArg();
        TupleExpr rightArg = union2.getRightArg();
        if (leftArg instanceof EmptySet) {
            union2.replaceWith(rightArg);
        } else if (rightArg instanceof EmptySet) {
            union2.replaceWith(leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            union2.replaceWith(leftArg);
        }
    }

    @Override
    public void meet(Difference difference2) {
        super.meet(difference2);
        TupleExpr leftArg = difference2.getLeftArg();
        TupleExpr rightArg = difference2.getRightArg();
        if (leftArg instanceof EmptySet) {
            difference2.replaceWith(leftArg);
        } else if (rightArg instanceof EmptySet) {
            difference2.replaceWith(leftArg);
        } else if (leftArg instanceof SingletonSet && rightArg instanceof SingletonSet) {
            difference2.replaceWith(new EmptySet());
        }
    }

    @Override
    public void meet(Intersection intersection2) {
        super.meet(intersection2);
        TupleExpr leftArg = intersection2.getLeftArg();
        TupleExpr rightArg = intersection2.getRightArg();
        if (leftArg instanceof EmptySet || rightArg instanceof EmptySet) {
            intersection2.replaceWith(new EmptySet());
        }
    }

    @Override
    protected void meetUnaryTupleOperator(UnaryTupleOperator node2) {
        super.meetUnaryTupleOperator(node2);
        if (node2.getArg() instanceof EmptySet) {
            node2.replaceWith(node2.getArg());
        }
    }

    @Override
    public void meet(Filter node2) {
        super.meet(node2);
        TupleExpr arg = node2.getArg();
        ValueExpr condition = node2.getCondition();
        if (!(arg instanceof EmptySet) && condition instanceof ValueConstant) {
            boolean conditionValue;
            try {
                conditionValue = QueryEvaluationUtil.getEffectiveBooleanValue(((ValueConstant)condition).getValue());
            }
            catch (ValueExprEvaluationException e2) {
                conditionValue = false;
            }
            if (!conditionValue) {
                node2.replaceWith(new EmptySet());
            } else {
                node2.replaceWith(arg);
            }
        }
    }

    @Override
    public void meet(Or or2) {
        super.meet(or2);
        if (or2.getLeftArg().equals(or2.getRightArg())) {
            or2.replaceWith(or2.getLeftArg());
        }
    }

    @Override
    public void meet(And and2) {
        super.meet(and2);
        if (and2.getLeftArg().equals(and2.getRightArg())) {
            and2.replaceWith(and2.getLeftArg());
        }
    }

    private boolean isWellDesigned(LeftJoin leftJoin) {
        QueryModelNode parent;
        VarNameCollector optionalVarCollector = new VarNameCollector();
        leftJoin.getRightArg().visit(optionalVarCollector);
        if (leftJoin.hasCondition()) {
            leftJoin.getCondition().visit(optionalVarCollector);
        }
        Set<String> problemVars = optionalVarCollector.getVarNames();
        problemVars.removeAll(leftJoin.getLeftArg().getBindingNames());
        if (problemVars.isEmpty()) {
            return true;
        }
        BindingCollector bindingCollector = new BindingCollector();
        QueryModelNode node2 = leftJoin;
        while ((parent = node2.getParentNode()) != null) {
            bindingCollector.setNodeToIgnore(node2);
            parent.visitChildren(bindingCollector);
            node2 = parent;
        }
        problemVars.retainAll(bindingCollector.getBindingNames());
        return problemVars.isEmpty();
    }

    private static class BindingCollector
    extends AbstractQueryModelVisitor<RuntimeException> {
        private QueryModelNode nodeToIgnore;
        private final Set<String> bindingNames = new HashSet<String>();

        private BindingCollector() {
        }

        public void setNodeToIgnore(QueryModelNode node2) {
            this.nodeToIgnore = node2;
        }

        public Set<String> getBindingNames() {
            return this.bindingNames;
        }

        @Override
        protected void meetNode(QueryModelNode node2) {
            if (node2 instanceof TupleExpr && node2 != this.nodeToIgnore) {
                TupleExpr tupleExpr = (TupleExpr)node2;
                this.bindingNames.addAll(tupleExpr.getBindingNames());
            }
        }
    }
}

