/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.impl;

import java.util.Set;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.Dataset;
import org.eclipse.rdf4j.query.algebra.Difference;
import org.eclipse.rdf4j.query.algebra.Distinct;
import org.eclipse.rdf4j.query.algebra.EmptySet;
import org.eclipse.rdf4j.query.algebra.Extension;
import org.eclipse.rdf4j.query.algebra.Filter;
import org.eclipse.rdf4j.query.algebra.Intersection;
import org.eclipse.rdf4j.query.algebra.Join;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.Order;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryRoot;
import org.eclipse.rdf4j.query.algebra.Reduced;
import org.eclipse.rdf4j.query.algebra.TupleExpr;
import org.eclipse.rdf4j.query.algebra.Union;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryOptimizer;
import org.eclipse.rdf4j.query.algebra.helpers.AbstractQueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.helpers.VarNameCollector;

public class FilterOptimizer
implements QueryOptimizer {
    @Override
    public void optimize(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings) {
        tupleExpr.visit(new FilterFinder(tupleExpr));
    }

    protected static class FilterRelocator
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected final Filter filter;
        protected final Set<String> filterVars;

        public static void relocate(Filter filter2) {
            filter2.visit(new FilterRelocator(filter2));
        }

        public FilterRelocator(Filter filter2) {
            this.filter = filter2;
            this.filterVars = VarNameCollector.process(filter2.getCondition());
        }

        @Override
        protected void meetNode(QueryModelNode node2) {
            assert (node2 instanceof TupleExpr);
            this.relocate(this.filter, (TupleExpr)node2);
        }

        @Override
        public void meet(Join join2) {
            if (join2.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                join2.getLeftArg().visit(this);
            } else if (join2.getRightArg().getBindingNames().containsAll(this.filterVars)) {
                join2.getRightArg().visit(this);
            } else {
                this.relocate(this.filter, join2);
            }
        }

        @Override
        public void meet(LeftJoin leftJoin) {
            if (leftJoin.getLeftArg().getBindingNames().containsAll(this.filterVars)) {
                leftJoin.getLeftArg().visit(this);
            } else {
                this.relocate(this.filter, leftJoin);
            }
        }

        @Override
        public void meet(Union union2) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, union2.getLeftArg());
            this.relocate(clone, union2.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Difference node2) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node2.getLeftArg());
            this.relocate(clone, node2.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Intersection node2) {
            Filter clone = new Filter();
            clone.setCondition(this.filter.getCondition().clone());
            this.relocate(this.filter, node2.getLeftArg());
            this.relocate(clone, node2.getRightArg());
            FilterRelocator.relocate(this.filter);
            FilterRelocator.relocate(clone);
        }

        @Override
        public void meet(Extension node2) {
            if (node2.getArg().getBindingNames().containsAll(this.filterVars)) {
                node2.getArg().visit(this);
            } else {
                this.relocate(this.filter, node2);
            }
        }

        @Override
        public void meet(EmptySet node2) {
            if (this.filter.getParentNode() != null) {
                this.filter.replaceWith(this.filter.getArg());
            }
        }

        @Override
        public void meet(Filter filter2) {
            filter2.getArg().visit(this);
        }

        @Override
        public void meet(Distinct node2) {
            node2.getArg().visit(this);
        }

        @Override
        public void meet(Order node2) {
            node2.getArg().visit(this);
        }

        @Override
        public void meet(QueryRoot node2) {
            node2.getArg().visit(this);
        }

        @Override
        public void meet(Reduced node2) {
            node2.getArg().visit(this);
        }

        protected void relocate(Filter filter2, TupleExpr newFilterArg) {
            if (filter2.getArg() != newFilterArg) {
                if (filter2.getParentNode() != null) {
                    filter2.replaceWith(filter2.getArg());
                }
                newFilterArg.replaceWith(filter2);
                filter2.setArg(newFilterArg);
            }
        }
    }

    protected static class FilterFinder
    extends AbstractQueryModelVisitor<RuntimeException> {
        protected final TupleExpr tupleExpr;

        public FilterFinder(TupleExpr tupleExpr) {
            this.tupleExpr = tupleExpr;
        }

        @Override
        public void meet(Filter filter2) {
            super.meet(filter2);
            FilterRelocator.relocate(filter2);
        }
    }
}

