/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation.function.xsd;

import java.math.BigDecimal;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.eclipse.rdf4j.query.algebra.evaluation.function.xsd.CastFunction;

public class DecimalCast
extends CastFunction {
    @Override
    protected Literal convert(ValueFactory valueFactory, Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            IRI datatype = literal.getDatatype();
            if (XMLDatatypeUtil.isNumericDatatype(datatype)) {
                try {
                    BigDecimal decimalValue = literal.decimalValue();
                    return valueFactory.createLiteral(decimalValue.toPlainString(), XMLSchema.DECIMAL);
                }
                catch (NumberFormatException e2) {
                    throw this.typeError(literal, e2);
                }
            }
            if (datatype.equals(XMLSchema.BOOLEAN)) {
                try {
                    return valueFactory.createLiteral(literal.booleanValue() ? "1.0" : "0.0", XMLSchema.DECIMAL);
                }
                catch (IllegalArgumentException e3) {
                    throw this.typeError(literal, e3);
                }
            }
        }
        throw this.typeError(value, null);
    }

    @Override
    protected IRI getXsdDatatype() {
        return XMLSchema.DECIMAL;
    }

    @Override
    protected boolean isValidForDatatype(String lexicalValue) {
        return XMLDatatypeUtil.isValidDecimal(lexicalValue);
    }
}

