/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.datatypes;

import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class XMLDateTime
implements Cloneable,
Comparable<XMLDateTime> {
    private String dateTimeString;
    private boolean isNegativeYear;
    private String year;
    private String months;
    private String days;
    private String hours;
    private String minutes;
    private String seconds;
    private String fractionalSeconds;
    private boolean isNegativeTimezone;
    private String hoursTimezone;
    private String minutesTimezone;
    private int iYear;
    private int iMonths;
    private int iDays;
    private int iHours;
    private int iMinutes;
    private int iSeconds;
    private double iFractionalSeconds;
    private int iHoursTimezone;
    private int iMinutesTimezone;
    private boolean isNormalized = false;

    public XMLDateTime(String dateTimeString) {
        this.dateTimeString = XMLDatatypeUtil.collapseWhiteSpace(dateTimeString);
        this.parseDateTimeString();
        this.setNumericFields();
        this.validateFieldValues();
    }

    private void parseDateTimeString() {
        if (this.dateTimeString.length() < 19) {
            throw new IllegalArgumentException("String value too short to be a valid xsd:dateTime value: " + this.dateTimeString);
        }
        String errMsg = "Invalid xsd:dateTime value: " + this.dateTimeString;
        StringTokenizer st = new StringTokenizer(this.dateTimeString, "+-:.TZ", true);
        try {
            String token;
            this.year = st.nextToken();
            this.isNegativeYear = this.year.equals("-");
            if (this.isNegativeYear) {
                this.year = st.nextToken();
            }
            this.verifyTokenValue(st.nextToken(), "-", errMsg);
            this.months = st.nextToken();
            this.verifyTokenValue(st.nextToken(), "-", errMsg);
            this.days = st.nextToken();
            this.verifyTokenValue(st.nextToken(), "T", errMsg);
            this.hours = st.nextToken();
            this.verifyTokenValue(st.nextToken(), ":", errMsg);
            this.minutes = st.nextToken();
            this.verifyTokenValue(st.nextToken(), ":", errMsg);
            this.seconds = st.nextToken();
            String string2 = token = st.hasMoreTokens() ? st.nextToken() : null;
            if (".".equals(token)) {
                this.fractionalSeconds = st.nextToken();
                String string3 = token = st.hasMoreTokens() ? st.nextToken() : null;
            }
            if ("+".equals(token) || "-".equals(token)) {
                this.isNegativeTimezone = "-".equals(token);
                this.hoursTimezone = st.nextToken();
                this.verifyTokenValue(st.nextToken(), ":", errMsg);
                this.minutesTimezone = st.nextToken();
            } else if ("Z".equals(token)) {
                this.isNegativeTimezone = false;
                this.minutesTimezone = "00";
                this.hoursTimezone = "00";
            }
            if (st.hasMoreTokens()) {
                throw new IllegalArgumentException(errMsg);
            }
        }
        catch (NoSuchElementException e2) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void verifyTokenValue(String token, String expected, String errMsg) {
        if (!token.equals(expected)) {
            throw new IllegalArgumentException(errMsg);
        }
    }

    private void setNumericFields() {
        try {
            this.iYear = Integer.parseInt(this.year);
            this.iMonths = Integer.parseInt(this.months);
            this.iDays = Integer.parseInt(this.days);
            this.iHours = Integer.parseInt(this.hours);
            this.iMinutes = Integer.parseInt(this.minutes);
            this.iSeconds = Integer.parseInt(this.seconds);
            if (this.fractionalSeconds != null) {
                this.iFractionalSeconds = Double.parseDouble("0." + this.fractionalSeconds);
            }
            if (this.hoursTimezone != null) {
                this.iHoursTimezone = Integer.parseInt(this.hoursTimezone);
            }
            if (this.minutesTimezone != null) {
                this.iMinutesTimezone = Integer.parseInt(this.minutesTimezone);
            }
        }
        catch (NumberFormatException e2) {
            throw new IllegalArgumentException("All fields must be numbers: " + this.dateTimeString);
        }
    }

    private void validateFieldValues() {
        if (this.year.length() < 4) {
            throw new IllegalArgumentException("Year field requires at least 4 digits: " + this.dateTimeString);
        }
        if (this.months.length() != 2) {
            throw new IllegalArgumentException("Month field must be two digits: " + this.dateTimeString);
        }
        if (this.days.length() != 2) {
            throw new IllegalArgumentException("Days field must be two digits: " + this.dateTimeString);
        }
        if (this.hours.length() != 2) {
            throw new IllegalArgumentException("Hours field must be two digits: " + this.dateTimeString);
        }
        if (this.minutes.length() != 2) {
            throw new IllegalArgumentException("Minutes field must be two digits: " + this.dateTimeString);
        }
        if (this.seconds.length() != 2) {
            throw new IllegalArgumentException("Seconds field must be two digits: " + this.dateTimeString);
        }
        if (this.hoursTimezone != null) {
            if (this.hoursTimezone.length() != 2) {
                throw new IllegalArgumentException("Timezone-hours field must be two digits: " + this.dateTimeString);
            }
            if (this.minutesTimezone.length() != 2) {
                throw new IllegalArgumentException("Timezone-minutes field must be two digits: " + this.dateTimeString);
            }
        }
        if (this.year.length() > 4 && this.year.charAt(0) == '0') {
            throw new IllegalArgumentException("Leading zeros in years with more than 4 digits are prohibited: " + this.dateTimeString);
        }
        if (this.iYear == 0) {
            throw new IllegalArgumentException("0000 is not a valid year: " + this.dateTimeString);
        }
        if (this.iDays < 1 || this.iDays > 31) {
            throw new IllegalArgumentException("invalid day value: " + this.dateTimeString);
        }
        if (this.iMonths < 1 || this.iMonths > 12) {
            throw new IllegalArgumentException("invalid month value: " + this.dateTimeString);
        }
        if (this.iDays == 31 && this.is30DayMonth(this.iMonths)) {
            throw new IllegalArgumentException("invalid dateTime value: " + this.dateTimeString);
        }
        if (this.iMonths == 2 && this.iDays > 28) {
            if (this.iDays == 29) {
                if (!this.isLeapYear(this.iYear)) {
                    throw new IllegalArgumentException("invalid dateTime value: " + this.dateTimeString);
                }
            } else {
                throw new IllegalArgumentException("invalid dateTime value: " + this.dateTimeString);
            }
        }
        if (this.iHours > 24) {
            throw new IllegalArgumentException("Invalid hour value: " + this.dateTimeString);
        }
        if (this.iMinutes > 59) {
            throw new IllegalArgumentException("Invalid minute value: " + this.dateTimeString);
        }
        if (this.iSeconds > 59) {
            throw new IllegalArgumentException("Invalid second value: " + this.dateTimeString);
        }
        if (this.iHours == 24 && (this.iMinutes != 0 || this.iSeconds != 0)) {
            throw new IllegalArgumentException("Invalid time: " + this.dateTimeString);
        }
        if (this.iHoursTimezone > 14 || this.iMinutesTimezone > 59 || this.iHoursTimezone == 14 && this.iMinutesTimezone != 0) {
            throw new IllegalArgumentException("Invalid timezone: " + this.dateTimeString);
        }
    }

    private boolean is30DayMonth(int month) {
        return month == 4 || month == 6 || month == 9 || month == 11;
    }

    private boolean isLeapYear(int year) {
        return year % 400 == 0 || year % 4 == 0 && year % 100 != 0;
    }

    public boolean isNormalized() {
        return this.isNormalized;
    }

    public void normalize() {
        if (this.isNormalized) {
            return;
        }
        if (this.iHours == 24 || this.hoursTimezone != null && (this.iHoursTimezone != 0 || this.iMinutesTimezone != 0)) {
            GregorianCalendar cal = new GregorianCalendar(this.iYear, this.iMonths - 1, this.iDays, this.iHours, this.iMinutes, this.iSeconds);
            if (this.isNegativeYear) {
                cal.set(0, 0);
            }
            if (this.isNegativeTimezone) {
                ((Calendar)cal).add(11, this.iHoursTimezone);
                ((Calendar)cal).add(12, this.iMinutesTimezone);
            } else {
                ((Calendar)cal).add(11, -this.iHoursTimezone);
                ((Calendar)cal).add(12, -this.iMinutesTimezone);
            }
            if (cal.get(0) == 0) {
                this.isNegativeYear = true;
            }
            this.iYear = cal.get(1);
            this.iMonths = cal.get(2) + 1;
            this.iDays = cal.get(5);
            this.iHours = cal.get(11);
            this.iMinutes = cal.get(12);
            this.iSeconds = cal.get(13);
            this.year = this.int2string(this.iYear, 4);
            this.months = this.int2string(this.iMonths, 2);
            this.days = this.int2string(this.iDays, 2);
            this.hours = this.int2string(this.iHours, 2);
            this.minutes = this.int2string(this.iMinutes, 2);
            this.seconds = this.int2string(this.iSeconds, 2);
            if (this.hoursTimezone != null) {
                this.iMinutesTimezone = 0;
                this.iHoursTimezone = 0;
                this.minutesTimezone = "00";
                this.hoursTimezone = "00";
                this.isNegativeTimezone = false;
            }
        }
        if (this.fractionalSeconds != null) {
            int zeroCount = 0;
            for (int i = this.fractionalSeconds.length() - 1; i >= 0 && this.fractionalSeconds.charAt(i) == '0'; --i) {
                ++zeroCount;
            }
            if (zeroCount == this.fractionalSeconds.length()) {
                this.fractionalSeconds = null;
            } else if (zeroCount > 0) {
                this.fractionalSeconds = this.fractionalSeconds.substring(0, this.fractionalSeconds.length() - zeroCount);
            }
        }
        this.isNormalized = true;
    }

    private String int2string(int iValue, int minDigits) {
        String result = String.valueOf(iValue);
        int zeroCount = minDigits - result.length();
        if (zeroCount > 0) {
            StringBuilder sb = new StringBuilder(minDigits);
            for (int i = 0; i < zeroCount; ++i) {
                sb.append('0');
            }
            sb.append(result);
            result = sb.toString();
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        if (this.isNegativeYear) {
            sb.append('-');
        }
        sb.append(this.year);
        sb.append('-');
        sb.append(this.months);
        sb.append('-');
        sb.append(this.days);
        sb.append('T');
        sb.append(this.hours);
        sb.append(':');
        sb.append(this.minutes);
        sb.append(':');
        sb.append(this.seconds);
        if (this.fractionalSeconds != null) {
            sb.append('.');
            sb.append(this.fractionalSeconds);
        }
        if (this.hoursTimezone != null) {
            if (this.iHoursTimezone == 0 && this.iMinutesTimezone == 0) {
                sb.append("Z");
            } else {
                if (this.isNegativeTimezone) {
                    sb.append('-');
                } else {
                    sb.append('+');
                }
                sb.append(this.hoursTimezone);
                sb.append(':');
                sb.append(this.minutesTimezone);
            }
        }
        return sb.toString();
    }

    @Override
    public int compareTo(XMLDateTime otherDT) {
        XMLDateTime thisDT = this;
        if (thisDT.hoursTimezone != null && (thisDT.iHoursTimezone != 0 || thisDT.iMinutesTimezone != 0)) {
            thisDT = (XMLDateTime)thisDT.clone();
            thisDT.normalize();
        }
        if (otherDT.hoursTimezone != null && (otherDT.iHoursTimezone != 0 || otherDT.iMinutesTimezone != 0)) {
            otherDT = (XMLDateTime)otherDT.clone();
            otherDT.normalize();
        }
        if (thisDT.isNegativeYear && !otherDT.isNegativeYear) {
            return -1;
        }
        if (!thisDT.isNegativeYear && otherDT.isNegativeYear) {
            return 1;
        }
        int result = 0;
        if (thisDT.iYear != otherDT.iYear) {
            result = thisDT.iYear - otherDT.iYear;
        } else if (thisDT.iMonths != otherDT.iMonths) {
            result = thisDT.iMonths - otherDT.iMonths;
        } else if (thisDT.iDays != otherDT.iDays) {
            result = thisDT.iDays - otherDT.iDays;
        } else if (thisDT.iHours != otherDT.iHours) {
            result = thisDT.iHours - otherDT.iHours;
        } else if (thisDT.iMinutes != otherDT.iMinutes) {
            result = thisDT.iMinutes - otherDT.iMinutes;
        } else if (thisDT.iSeconds != otherDT.iSeconds) {
            result = thisDT.iSeconds - otherDT.iSeconds;
        } else if (thisDT.iFractionalSeconds != otherDT.iFractionalSeconds) {
            int n = result = thisDT.iFractionalSeconds < otherDT.iFractionalSeconds ? -1 : 1;
        }
        if (thisDT.isNegativeYear) {
            result = -result;
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e2) {
            throw new RuntimeException(e2);
        }
    }
}

