/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.common.iteration;

import java.util.NoSuchElementException;
import java.util.Objects;
import org.eclipse.rdf4j.common.iteration.AbstractCloseableIteration;
import org.eclipse.rdf4j.common.iteration.Iteration;
import org.eclipse.rdf4j.common.iteration.Iterations;

public abstract class ExceptionConvertingIteration<E, X extends Exception>
extends AbstractCloseableIteration<E, X> {
    private final Iteration<? extends E, ? extends Exception> iter;

    public ExceptionConvertingIteration(Iteration<? extends E, ? extends Exception> iter) {
        this.iter = Objects.requireNonNull(iter, "The iterator was null");
    }

    protected abstract X convert(Exception var1);

    @Override
    public boolean hasNext() throws X {
        if (this.isClosed()) {
            return false;
        }
        try {
            boolean result = this.iter.hasNext();
            if (!result) {
                this.close();
            }
            return result;
        }
        catch (Exception e2) {
            throw this.convert(e2);
        }
    }

    @Override
    public E next() throws X {
        if (this.isClosed()) {
            throw new NoSuchElementException("The iteration has been closed.");
        }
        try {
            return this.iter.next();
        }
        catch (NoSuchElementException e2) {
            this.close();
            throw e2;
        }
        catch (IllegalStateException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw this.convert(e4);
        }
    }

    @Override
    public void remove() throws X {
        if (this.isClosed()) {
            throw new IllegalStateException("The iteration has been closed.");
        }
        try {
            this.iter.remove();
        }
        catch (UnsupportedOperationException e2) {
            throw e2;
        }
        catch (IllegalStateException e3) {
            throw e3;
        }
        catch (Exception e4) {
            throw this.convert(e4);
        }
    }

    @Override
    protected void handleClose() throws X {
        try {
            super.handleClose();
        }
        finally {
            try {
                Iterations.closeCloseable(this.iter);
            }
            catch (Exception e2) {
                throw this.convert(e2);
            }
        }
    }
}

