/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.util;

import java.util.Collection;
import java.util.Comparator;
import org.apache.lucene.util.ArrayIntroSorter;
import org.apache.lucene.util.ArrayTimSorter;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.RamUsageEstimator;

public final class ArrayUtil {
    public static final int MAX_ARRAY_LENGTH = Integer.MAX_VALUE - RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
    private static final Comparator<?> NATURAL_COMPARATOR = new NaturalComparator();

    private ArrayUtil() {
    }

    public static int parseInt(char[] chars2) throws NumberFormatException {
        return ArrayUtil.parseInt(chars2, 0, chars2.length, 10);
    }

    public static int parseInt(char[] chars2, int offset, int len) throws NumberFormatException {
        return ArrayUtil.parseInt(chars2, offset, len, 10);
    }

    public static int parseInt(char[] chars2, int offset, int len, int radix) throws NumberFormatException {
        boolean negative;
        if (chars2 == null || radix < 2 || radix > 36) {
            throw new NumberFormatException();
        }
        int i = 0;
        if (len == 0) {
            throw new NumberFormatException("chars length is 0");
        }
        boolean bl = negative = chars2[offset + i] == '-';
        if (negative && ++i == len) {
            throw new NumberFormatException("can't convert to an int");
        }
        if (negative) {
            ++offset;
            --len;
        }
        return ArrayUtil.parse(chars2, offset, len, radix, negative);
    }

    private static int parse(char[] chars2, int offset, int len, int radix, boolean negative) throws NumberFormatException {
        int max2 = Integer.MIN_VALUE / radix;
        int result = 0;
        for (int i = 0; i < len; ++i) {
            int digit = Character.digit(chars2[i + offset], radix);
            if (digit == -1) {
                throw new NumberFormatException("Unable to parse");
            }
            if (max2 > result) {
                throw new NumberFormatException("Unable to parse");
            }
            int next2 = result * radix - digit;
            if (next2 > result) {
                throw new NumberFormatException("Unable to parse");
            }
            result = next2;
        }
        if (!negative && (result = -result) < 0) {
            throw new NumberFormatException("Unable to parse");
        }
        return result;
    }

    public static int oversize(int minTargetSize, int bytesPerElement) {
        int newSize;
        if (minTargetSize < 0) {
            throw new IllegalArgumentException("invalid array size " + minTargetSize);
        }
        if (minTargetSize == 0) {
            return 0;
        }
        if (minTargetSize > MAX_ARRAY_LENGTH) {
            throw new IllegalArgumentException("requested array size " + minTargetSize + " exceeds maximum array in java (" + MAX_ARRAY_LENGTH + ")");
        }
        int extra = minTargetSize >> 3;
        if (extra < 3) {
            extra = 3;
        }
        if ((newSize = minTargetSize + extra) + 7 < 0 || newSize + 7 > MAX_ARRAY_LENGTH) {
            return MAX_ARRAY_LENGTH;
        }
        if (Constants.JRE_IS_64BIT) {
            switch (bytesPerElement) {
                case 4: {
                    return newSize + 1 & 0x7FFFFFFE;
                }
                case 2: {
                    return newSize + 3 & 0x7FFFFFFC;
                }
                case 1: {
                    return newSize + 7 & 0x7FFFFFF8;
                }
            }
            return newSize;
        }
        switch (bytesPerElement) {
            case 2: {
                return newSize + 1 & 0x7FFFFFFE;
            }
            case 1: {
                return newSize + 3 & 0x7FFFFFFC;
            }
        }
        return newSize;
    }

    public static int getShrinkSize(int currentSize, int targetSize, int bytesPerElement) {
        int newSize = ArrayUtil.oversize(targetSize, bytesPerElement);
        if (newSize < currentSize / 2) {
            return newSize;
        }
        return currentSize;
    }

    public static short[] grow(short[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            short[] newArray = new short[ArrayUtil.oversize(minSize, 2)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static short[] grow(short[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static float[] grow(float[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            float[] newArray = new float[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static float[] grow(float[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static double[] grow(double[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            double[] newArray = new double[ArrayUtil.oversize(minSize, 8)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static double[] grow(double[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static short[] shrink(short[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 2);
        if (newSize != array2.length) {
            short[] newArray = new short[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static int[] grow(int[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            int[] newArray = new int[ArrayUtil.oversize(minSize, 4)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static int[] grow(int[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static int[] shrink(int[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 4);
        if (newSize != array2.length) {
            int[] newArray = new int[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static long[] grow(long[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            long[] newArray = new long[ArrayUtil.oversize(minSize, 8)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static long[] grow(long[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static long[] shrink(long[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 8);
        if (newSize != array2.length) {
            long[] newArray = new long[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static byte[] grow(byte[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            byte[] newArray = new byte[ArrayUtil.oversize(minSize, 1)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static byte[] grow(byte[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static byte[] shrink(byte[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 1);
        if (newSize != array2.length) {
            byte[] newArray = new byte[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static boolean[] grow(boolean[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            boolean[] newArray = new boolean[ArrayUtil.oversize(minSize, 1)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static boolean[] grow(boolean[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static boolean[] shrink(boolean[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 1);
        if (newSize != array2.length) {
            boolean[] newArray = new boolean[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static char[] grow(char[] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            char[] newArray = new char[ArrayUtil.oversize(minSize, 2)];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static char[] grow(char[] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static char[] shrink(char[] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, 2);
        if (newSize != array2.length) {
            char[] newArray = new char[newSize];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static int[][] grow(int[][] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            int[][] newArray = new int[ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static int[][] grow(int[][] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static int[][] shrink(int[][] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (newSize != array2.length) {
            int[][] newArray = new int[newSize][];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static float[][] grow(float[][] array2, int minSize) {
        assert (minSize >= 0) : "size must be positive (got " + minSize + "): likely integer overflow?";
        if (array2.length < minSize) {
            float[][] newArray = new float[ArrayUtil.oversize(minSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF)][];
            System.arraycopy(array2, 0, newArray, 0, array2.length);
            return newArray;
        }
        return array2;
    }

    public static float[][] grow(float[][] array2) {
        return ArrayUtil.grow(array2, 1 + array2.length);
    }

    public static float[][] shrink(float[][] array2, int targetSize) {
        assert (targetSize >= 0) : "size must be positive (got " + targetSize + "): likely integer overflow?";
        int newSize = ArrayUtil.getShrinkSize(array2.length, targetSize, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
        if (newSize != array2.length) {
            float[][] newArray = new float[newSize][];
            System.arraycopy(array2, 0, newArray, 0, newSize);
            return newArray;
        }
        return array2;
    }

    public static int hashCode(char[] array2, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array2[i];
        }
        return code;
    }

    public static int hashCode(byte[] array2, int start, int end) {
        int code = 0;
        for (int i = end - 1; i >= start; --i) {
            code = code * 31 + array2[i];
        }
        return code;
    }

    public static boolean equals(char[] left2, int offsetLeft, char[] right2, int offsetRight, int length) {
        if (offsetLeft + length <= left2.length && offsetRight + length <= right2.length) {
            for (int i = 0; i < length; ++i) {
                if (left2[offsetLeft + i] == right2[offsetRight + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(byte[] left2, int offsetLeft, byte[] right2, int offsetRight, int length) {
        if (offsetLeft + length <= left2.length && offsetRight + length <= right2.length) {
            for (int i = 0; i < length; ++i) {
                if (left2[offsetLeft + i] == right2[offsetRight + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean equals(int[] left2, int offsetLeft, int[] right2, int offsetRight, int length) {
        if (offsetLeft + length <= left2.length && offsetRight + length <= right2.length) {
            for (int i = 0; i < length; ++i) {
                if (left2[offsetLeft + i] == right2[offsetRight + i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static int[] toIntArray(Collection<Integer> ints2) {
        int[] result = new int[ints2.size()];
        int upto = 0;
        for (int v : ints2) {
            result[upto++] = v;
        }
        assert (upto == result.length);
        return result;
    }

    public static <T extends Comparable<? super T>> Comparator<T> naturalComparator() {
        return NATURAL_COMPARATOR;
    }

    public static <T> void swap(T[] arr, int i, int j) {
        T tmp = arr[i];
        arr[i] = arr[j];
        arr[j] = tmp;
    }

    public static <T> void introSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp2) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayIntroSorter<T>(a, comp2).sort(fromIndex, toIndex);
    }

    public static <T> void introSort(T[] a, Comparator<? super T> comp2) {
        ArrayUtil.introSort(a, 0, a.length, comp2);
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.introSort(a, fromIndex, toIndex, ArrayUtil.naturalComparator());
    }

    public static <T extends Comparable<? super T>> void introSort(T[] a) {
        ArrayUtil.introSort(a, (int)0, (int)a.length);
    }

    public static <T> void timSort(T[] a, int fromIndex, int toIndex, Comparator<? super T> comp2) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        new ArrayTimSorter<T>(a, comp2, a.length / 64).sort(fromIndex, toIndex);
    }

    public static <T> void timSort(T[] a, Comparator<? super T> comp2) {
        ArrayUtil.timSort(a, 0, a.length, comp2);
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a, int fromIndex, int toIndex) {
        if (toIndex - fromIndex <= 1) {
            return;
        }
        ArrayUtil.timSort(a, fromIndex, toIndex, ArrayUtil.naturalComparator());
    }

    public static <T extends Comparable<? super T>> void timSort(T[] a) {
        ArrayUtil.timSort(a, (int)0, (int)a.length);
    }

    private static class NaturalComparator<T extends Comparable<? super T>>
    implements Comparator<T> {
        NaturalComparator() {
        }

        @Override
        public int compare(T o1, T o2) {
            return o1.compareTo(o2);
        }
    }
}

