/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;

public final class TrackingDirectoryWrapper
extends FilterDirectory {
    private final Set<String> createdFileNames = Collections.synchronizedSet(new HashSet());

    public TrackingDirectoryWrapper(Directory in) {
        super(in);
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.in.deleteFile(name2);
        this.createdFileNames.remove(name2);
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        IndexOutput output = this.in.createOutput(name2, context);
        this.createdFileNames.add(name2);
        return output;
    }

    @Override
    public void copyFrom(Directory from, String src, String dest, IOContext context) throws IOException {
        this.in.copyFrom(from, src, dest, context);
        this.createdFileNames.add(dest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void renameFile(String source2, String dest) throws IOException {
        this.in.renameFile(source2, dest);
        Set<String> set2 = this.createdFileNames;
        synchronized (set2) {
            this.createdFileNames.add(dest);
            this.createdFileNames.remove(source2);
        }
    }

    public Set<String> getCreatedFiles() {
        return this.createdFileNames;
    }
}

