/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RAMFile;

public class RAMInputStream
extends IndexInput
implements Cloneable {
    static final int BUFFER_SIZE = 1024;
    private final RAMFile file;
    private final long length;
    private byte[] currentBuffer;
    private int currentBufferIndex;
    private int bufferPosition;
    private long bufferStart;
    private int bufferLength;

    public RAMInputStream(String name2, RAMFile f) throws IOException {
        this(name2, f, f.length);
    }

    RAMInputStream(String name2, RAMFile f, long length) throws IOException {
        super("RAMInputStream(name=" + name2 + ")");
        this.file = f;
        this.length = length;
        if (length / 1024L >= Integer.MAX_VALUE) {
            throw new IOException("RAMInputStream too large length=" + length + ": " + name2);
        }
        this.currentBufferIndex = -1;
        this.currentBuffer = null;
    }

    @Override
    public void close() {
    }

    @Override
    public long length() {
        return this.length;
    }

    @Override
    public byte readByte() throws IOException {
        if (this.bufferPosition >= this.bufferLength) {
            ++this.currentBufferIndex;
            this.switchCurrentBuffer(true);
        }
        return this.currentBuffer[this.bufferPosition++];
    }

    @Override
    public void readBytes(byte[] b, int offset, int len) throws IOException {
        while (len > 0) {
            int remainInBuffer;
            if (this.bufferPosition >= this.bufferLength) {
                ++this.currentBufferIndex;
                this.switchCurrentBuffer(true);
            }
            int bytesToCopy = len < (remainInBuffer = this.bufferLength - this.bufferPosition) ? len : remainInBuffer;
            System.arraycopy(this.currentBuffer, this.bufferPosition, b, offset, bytesToCopy);
            offset += bytesToCopy;
            len -= bytesToCopy;
            this.bufferPosition += bytesToCopy;
        }
    }

    private final void switchCurrentBuffer(boolean enforceEOF) throws IOException {
        this.bufferStart = 1024L * (long)this.currentBufferIndex;
        if (this.bufferStart > this.length || this.currentBufferIndex >= this.file.numBuffers()) {
            if (enforceEOF) {
                throw new EOFException("read past EOF: " + this);
            }
            --this.currentBufferIndex;
            this.bufferPosition = 1024;
        } else {
            this.currentBuffer = this.file.getBuffer(this.currentBufferIndex);
            this.bufferPosition = 0;
            long buflen = this.length - this.bufferStart;
            this.bufferLength = buflen > 1024L ? 1024 : (int)buflen;
        }
    }

    @Override
    public long getFilePointer() {
        return this.currentBufferIndex < 0 ? 0L : this.bufferStart + (long)this.bufferPosition;
    }

    @Override
    public void seek(long pos) throws IOException {
        if (this.currentBuffer == null || pos < this.bufferStart || pos >= this.bufferStart + 1024L) {
            this.currentBufferIndex = (int)(pos / 1024L);
            this.switchCurrentBuffer(false);
        }
        this.bufferPosition = (int)(pos % 1024L);
    }

    @Override
    public IndexInput slice(String sliceDescription, final long offset, long length) throws IOException {
        if (offset < 0L || length < 0L || offset + length > this.length) {
            throw new IllegalArgumentException("slice() " + sliceDescription + " out of bounds: " + this);
        }
        return new RAMInputStream(this.getFullSliceDescription(sliceDescription), this.file, offset + length){
            {
                super(x0, x1, x2);
                this.seek(0L);
            }

            @Override
            public void seek(long pos) throws IOException {
                if (pos < 0L) {
                    throw new IllegalArgumentException("Seeking to negative position: " + this);
                }
                super.seek(pos + offset);
            }

            @Override
            public long getFilePointer() {
                return super.getFilePointer() - offset;
            }

            @Override
            public long length() {
                return super.length() - offset;
            }

            @Override
            public IndexInput slice(String sliceDescription, long ofs, long len) throws IOException {
                return super.slice(sliceDescription, offset + ofs, len);
            }
        };
    }
}

