/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.FSLockFactory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.LockFactory;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;

public abstract class FSDirectory
extends BaseDirectory {
    protected final Path directory;

    protected FSDirectory(Path path2, LockFactory lockFactory) throws IOException {
        super(lockFactory);
        Files.createDirectories(path2, new FileAttribute[0]);
        this.directory = path2.toRealPath(new LinkOption[0]);
    }

    public static FSDirectory open(Path path2) throws IOException {
        return FSDirectory.open(path2, FSLockFactory.getDefault());
    }

    public static FSDirectory open(Path path2, LockFactory lockFactory) throws IOException {
        if (Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path2, lockFactory);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path2, lockFactory);
        }
        return new NIOFSDirectory(path2, lockFactory);
    }

    public static String[] listAll(Path dir2) throws IOException {
        ArrayList<String> entries = new ArrayList<String>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(dir2);){
            for (Path path2 : stream) {
                entries.add(path2.getFileName().toString());
            }
        }
        return entries.toArray(new String[entries.size()]);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public long fileLength(String name2) throws IOException {
        this.ensureOpen();
        return Files.size(this.directory.resolve(name2));
    }

    @Override
    public void deleteFile(String name2) throws IOException {
        this.ensureOpen();
        Files.delete(this.directory.resolve(name2));
    }

    @Override
    public IndexOutput createOutput(String name2, IOContext context) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(name2);
        return new FSIndexOutput(name2);
    }

    protected void ensureCanWrite(String name2) throws IOException {
        Files.deleteIfExists(this.directory.resolve(name2));
    }

    @Override
    public void sync(Collection<String> names) throws IOException {
        this.ensureOpen();
        for (String name2 : names) {
            this.fsync(name2);
        }
    }

    @Override
    public void renameFile(String source2, String dest) throws IOException {
        this.ensureOpen();
        Files.move(this.directory.resolve(source2), this.directory.resolve(dest), StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(this.directory, true);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    public Path getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.directory + " lockFactory=" + this.lockFactory;
    }

    protected void fsync(String name2) throws IOException {
        IOUtils.fsync(this.directory.resolve(name2), false);
    }

    final class FSIndexOutput
    extends OutputStreamIndexOutput {
        static final int CHUNK_SIZE = 8192;

        public FSIndexOutput(String name2) throws IOException {
            super("FSIndexOutput(path=\"" + FSDirectory.this.directory.resolve(name2) + "\")", new FilterOutputStream(Files.newOutputStream(FSDirectory.this.directory.resolve(name2), new OpenOption[0])){

                @Override
                public void write(byte[] b, int offset, int length) throws IOException {
                    while (length > 0) {
                        int chunk2 = Math.min(length, 8192);
                        this.out.write(b, offset, chunk2);
                        length -= chunk2;
                        offset += chunk2;
                    }
                }
            }, 8192);
        }
    }
}

